/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class WellImageCache {
    private final Map<InternalPlateWellImageReference, SoftReference<Map<InternalTileChannelReference, CachedImage>>> cacheMap = new HashMap<InternalPlateWellImageReference, SoftReference<Map<InternalTileChannelReference, CachedImage>>>();

    WellImageCache() {
    }

    synchronized WellImages getWellImages(PlateImageReference imageRef, ImageSize size, ImageDatasetMetadata imageMetadata) {
        Map<InternalTileChannelReference, CachedImage> cachedImageOrNull;
        InternalPlateWellImageReference plateWellRef = InternalPlateWellImageReference.fromPlateImageReference(imageRef, size);
        SoftReference<Map<InternalTileChannelReference, CachedImage>> cachedImageRefOrNull = this.cacheMap.get(plateWellRef);
        Map<InternalTileChannelReference, CachedImage> map = cachedImageOrNull = cachedImageRefOrNull == null ? null : cachedImageRefOrNull.get();
        if (cachedImageOrNull == null) {
            HashMap<InternalTileChannelReference, CachedImage> emptyImages = new HashMap<InternalTileChannelReference, CachedImage>();
            int tile = 0;
            while (tile < imageMetadata.getNumberOfTiles()) {
                for (String channel : imageMetadata.getChannelCodes()) {
                    emptyImages.put(new InternalTileChannelReference(tile, channel), new CachedImage());
                }
                ++tile;
            }
            this.cacheMap.put(plateWellRef, new SoftReference(emptyImages));
            return new WellImages(emptyImages, true);
        }
        return new WellImages(cachedImageOrNull, false);
    }

    void clear() {
        this.cacheMap.clear();
    }

    static final class CachedImage {
        private final CountDownLatch ready = new CountDownLatch(1);
        private byte[] imageData;
        private IOException ioe;
        private RuntimeException rex;

        CachedImage() {
        }

        void set(byte[] imageData) {
            this.imageData = imageData;
            this.ready.countDown();
        }

        byte[] getImageData() throws IOException {
            try {
                this.ready.await();
                if (this.ioe != null) {
                    throw this.ioe;
                }
                if (this.rex != null) {
                    throw this.rex;
                }
                return this.imageData;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Image fetching interrupted.");
            }
        }

        void release(IOException ex) {
            this.ioe = ex;
            this.ready.countDown();
        }

        void release(RuntimeException ex) {
            if (this.ready.getCount() > 0L) {
                this.rex = ex;
                this.ready.countDown();
            }
        }
    }

    @JsonObject(value="InternalPlateWellImageReference")
    private static final class InternalPlateWellImageReference
    extends DatasetIdentifier {
        private static final long serialVersionUID = 1L;
        private final WellPosition wellPosition;
        private final ImageSize size;

        private InternalPlateWellImageReference(WellPosition wellPosition, ImageSize size, IDatasetIdentifier dataset) {
            super(dataset.getDatasetCode(), dataset.getDatastoreServerUrl());
            this.wellPosition = wellPosition;
            this.size = size;
        }

        static InternalPlateWellImageReference fromPlateImageReference(PlateImageReference ref, ImageSize size) {
            return new InternalPlateWellImageReference(ref.getWellPosition(), size, ref);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + super.hashCode();
            result = 31 * result + this.wellPosition.hashCode();
            result = 31 * result + this.size.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            InternalPlateWellImageReference other = (InternalPlateWellImageReference)obj;
            return this.wellPosition.equals(other.wellPosition) && this.size.equals(other.size);
        }
    }

    private static final class InternalTileChannelReference {
        private final int tile;
        private final String channel;

        private InternalTileChannelReference(int tile, String channel) {
            this.tile = tile;
            this.channel = channel;
        }

        static InternalTileChannelReference fromPlateImageReference(PlateImageReference ref) {
            return new InternalTileChannelReference(ref.getTile(), ref.getChannel());
        }

        public String toString() {
            return "InternalTileChannelReference [tile=" + this.tile + ", channel=" + this.channel + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
            result = 31 * result + this.tile;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InternalTileChannelReference other = (InternalTileChannelReference)obj;
            if (this.channel == null ? other.channel != null : !this.channel.equals(other.channel)) {
                return false;
            }
            return this.tile == other.tile;
        }
    }

    static final class WellImages {
        private final Map<InternalTileChannelReference, CachedImage> imageMap;
        private final boolean loaderCall;

        WellImages(Map<InternalTileChannelReference, CachedImage> imageMap, boolean loaderCall) {
            this.imageMap = imageMap;
            this.loaderCall = loaderCall;
        }

        void putImage(PlateImageReference ref, byte[] imageData) {
            CachedImage image = this.imageMap.get(InternalTileChannelReference.fromPlateImageReference(ref));
            image.set(imageData);
        }

        CachedImage getImage(PlateImageReference ref) {
            return this.imageMap.get(InternalTileChannelReference.fromPlateImageReference(ref));
        }

        boolean isLoaderCall() {
            return this.loaderCall;
        }

        void cancel(IOException ex) {
            for (CachedImage image : this.imageMap.values()) {
                image.release(ex);
            }
        }

        void cancel(RuntimeException ex) {
            for (CachedImage image : this.imageMap.values()) {
                image.release(ex);
            }
        }
    }
}

