/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.client;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnknownServiceConversationException;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceMessageTransportWithControl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class ClientResponseMessageMultiplexer {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ClientResponseMessageMultiplexer.class);
    private final Map<String, IServiceMessageTransportWithControl> conversations = new ConcurrentHashMap<String, IServiceMessageTransportWithControl>();

    ClientResponseMessageMultiplexer() {
    }

    IServiceMessageTransport getIncomingTransport() {
        return new IServiceMessageTransport(){

            @Override
            public void send(ServiceMessage message) {
                String conversationId = message.getConversationId();
                IServiceMessageTransportWithControl transport = (IServiceMessageTransportWithControl)ClientResponseMessageMultiplexer.this.conversations.get(conversationId);
                if (transport == null) {
                    String msg = String.format("Message for unknown service conversation '%s'", conversationId);
                    operationLog.error(msg);
                    throw new UnknownServiceConversationException(msg);
                }
                if (message.isException()) {
                    transport.sendException(message);
                } else {
                    transport.send(message);
                }
            }
        };
    }

    void addConversation(String serviceConversationId, IServiceMessageTransportWithControl responseMessageTransport) {
        this.conversations.put(serviceConversationId, responseMessageTransport);
    }

    boolean removeConversation(String serviceConversationId) {
        return this.conversations.remove(serviceConversationId) != null;
    }
}

