/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1;

import ch.systemsx.cisd.common.api.retry.Retry;
import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSet {
    private final IOpenbisServiceFacade facade;
    private final IDssComponent dssComponent;
    private ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet metadata;
    private List<DataSet> containedDataSets;
    private IDataSetDss dataSetDss;

    protected DataSet() {
        this.facade = null;
        this.dssComponent = null;
    }

    public DataSet(IOpenbisServiceFacade facade, IDssComponent dssComponent, ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet metadata, IDataSetDss dataSetDss) {
        this.facade = facade;
        this.dssComponent = dssComponent;
        this.metadata = metadata;
        this.dataSetDss = dataSetDss;
        assert (metadata != null || dataSetDss != null);
    }

    @Retry
    public String getCode() {
        return this.metadata == null ? this.dataSetDss.getCode() : this.metadata.getCode();
    }

    @Retry
    public String getExperimentIdentifier() {
        return this.getMetadata().getExperimentIdentifier();
    }

    @Retry
    public String getSampleIdentifierOrNull() {
        return this.getMetadata().getSampleIdentifierOrNull();
    }

    @Retry
    public String getDataSetTypeCode() {
        return this.getMetadata().getDataSetTypeCode();
    }

    @Retry
    public Date getRegistrationDate() {
        return this.getMetadata().getRegistrationDate();
    }

    @Retry
    public HashMap<String, String> getProperties() {
        return this.getMetadata().getProperties();
    }

    @Retry
    public EnumSet<DataSet.Connections> getRetrievedConnections() {
        return this.getMetadata().getRetrievedConnections();
    }

    @Retry
    public List<String> getParentCodes() {
        return this.getMetadata().getParentCodes();
    }

    @Retry
    public List<String> getChildrenCodes() {
        return this.getMetadata().getChildrenCodes();
    }

    @Retry
    public boolean isContainerDataSet() {
        return this.getMetadata().isContainerDataSet();
    }

    @Retry
    public List<DataSet> getContainedDataSets() {
        if (this.containedDataSets == null) {
            this.containedDataSets = new ArrayList<DataSet>();
            List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> primitiveContainedDataSets = this.getMetadata().getContainedDataSets();
            for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet primitiveContainedDataSet : primitiveContainedDataSets) {
                DataSet containedDataSet = new DataSet(this.facade, this.dssComponent, primitiveContainedDataSet, null);
                this.containedDataSets.add(containedDataSet);
            }
        }
        return this.containedDataSets;
    }

    @Retry
    public DataSet getPrimaryDataSetOrNull() {
        if (!this.isContainerDataSet()) {
            return this;
        }
        Pattern containerDataSetTypePattern = Pattern.compile("(.*)_CONTAINER(.*)");
        Matcher matcher = containerDataSetTypePattern.matcher(this.getDataSetTypeCode());
        if (!matcher.matches()) {
            return null;
        }
        String primaryDataSetType = matcher.group(1);
        if (primaryDataSetType == null) {
            primaryDataSetType = matcher.group(2);
        } else if (matcher.group(2) != null) {
            primaryDataSetType = String.valueOf(primaryDataSetType) + matcher.group(2);
        }
        if (primaryDataSetType == null) {
            return null;
        }
        List<DataSet> contained = this.getContainedDataSets();
        ArrayList<DataSet> matchedDataSets = new ArrayList<DataSet>();
        for (DataSet ds : contained) {
            if (!primaryDataSetType.equals(ds.getDataSetTypeCode())) continue;
            matchedDataSets.add(ds);
        }
        if (1 == matchedDataSets.size()) {
            return (DataSet)matchedDataSets.get(0);
        }
        return null;
    }

    @Retry
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)obj;
        return this.getMetadata().equals(other.getMetadata());
    }

    @Retry
    public int hashCode() {
        return this.getMetadata().hashCode();
    }

    @Retry
    public String toString() {
        return this.getMetadata().toString();
    }

    @Retry
    public FileInfoDssDTO[] listFiles(String startPath, boolean isRecursive) throws IllegalArgumentException, InvalidSessionException {
        return this.getDataSetDss().listFiles(startPath, isRecursive);
    }

    @Retry
    public InputStream getFile(String path) throws IllegalArgumentException, InvalidSessionException {
        return this.getDataSetDss().getFile(path);
    }

    @Retry
    public File tryLinkToContents(String overrideStoreRootPathOrNull) throws IllegalArgumentException, InvalidSessionException {
        return this.getDataSetDss().tryLinkToContents(overrideStoreRootPathOrNull);
    }

    @Retry
    public File getLinkOrCopyOfContents(String overrideStoreRootPathOrNull, File downloadDir) throws IllegalArgumentException, InvalidSessionException {
        return this.getDataSetDss().getLinkOrCopyOfContents(overrideStoreRootPathOrNull, downloadDir);
    }

    @Retry
    public File getLinkOrCopyOfContent(String overrideStoreRootPathOrNull, File downloadDir, String pathInDataSet) throws IllegalArgumentException, InvalidSessionException {
        return this.getDataSetDss().getLinkOrCopyOfContent(overrideStoreRootPathOrNull, downloadDir, pathInDataSet);
    }

    public IDataSetDss getDataSetDss() {
        if (this.dataSetDss == null) {
            RetryCaller<IDataSetDss, RuntimeException> caller = new RetryCaller<IDataSetDss, RuntimeException>(){

                @Override
                protected IDataSetDss call() {
                    return DataSet.this.dssComponent.getDataSet(DataSet.this.getMetadata().getCode());
                }
            };
            this.dataSetDss = RetryProxyFactory.createProxy((IDataSetDss)caller.callWithRetry());
        }
        return this.dataSetDss;
    }

    private ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet getMetadata() {
        RetryCaller<DataSet, RuntimeException> caller;
        DataSet dataSetWithMetaData;
        if (this.metadata == null && (dataSetWithMetaData = (DataSet)(caller = new RetryCaller<DataSet, RuntimeException>(){

            @Override
            protected DataSet call() {
                return DataSet.this.facade.getDataSet(DataSet.this.dataSetDss.getCode());
            }
        }).callWithRetry()) != null) {
            this.metadata = dataSetWithMetaData.getMetadata();
        }
        return this.metadata;
    }
}

