/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1;

import ch.systemsx.cisd.common.api.retry.Retry;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public interface ISimpleOpenbisServiceFacade {
    @Retry
    public List<Project> listProjects();

    @Retry
    public List<SpaceWithProjectsAndRoleAssignments> getSpacesWithProjects();

    @Retry
    public List<Experiment> getExperiments(List<String> var1);

    @Retry
    public List<Experiment> listExperimentsForProjects(List<String> var1);

    @Retry
    public List<Experiment> listExperimentsHavingSamplesForProjects(List<String> var1);

    @Retry
    public List<Experiment> listExperimentsHavingDataSetsForProjects(List<String> var1);

    @Retry
    public List<Sample> getSamples(List<String> var1);

    @Retry
    public List<Sample> getSamples(List<String> var1, EnumSet<SampleFetchOption> var2);

    @Retry
    public List<Sample> listSamplesForExperiments(List<String> var1);

    @Retry
    public List<Sample> listSamplesForExperiments(List<String> var1, EnumSet<SampleFetchOption> var2);

    @Retry
    public List<Sample> listSamplesForProjects(List<String> var1);

    @Retry
    public List<Sample> listSamplesForProjects(List<String> var1, EnumSet<SampleFetchOption> var2);

    @Retry
    public DataSet getDataSet(String var1);

    @Retry
    public List<DataSet> getDataSets(List<String> var1);

    @Retry
    public List<DataSet> listDataSetsForExperiments(List<String> var1);

    @Retry
    public List<DataSet> listDataSetsForSamples(List<String> var1);

    @Retry
    public List<DataSetType> listDataSetTypes();

    @Retry
    public List<Vocabulary> listVocabularies();

    public DataSet putDataSet(NewDataSetDTO var1, File var2);

    @Retry
    public List<ValidationError> validateDataSet(NewDataSetDTO var1, File var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public Map<String, String> extractMetadata(NewDataSetDTO var1, File var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public void checkSession() throws InvalidSessionException;

    public void logout();
}

