/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Translator {
    public static Role translate(RoleWithHierarchy role) {
        return Translator.translate(role.getRoleCode(), role.getRoleLevel().equals((Object)RoleWithHierarchy.RoleLevel.SPACE));
    }

    public static Role translate(RoleWithHierarchy.RoleCode roleCode, boolean spaceLevel) {
        return new Role(roleCode.name(), spaceLevel);
    }

    public static List<Project> translateProjects(List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project> projects) {
        ArrayList<Project> translated = new ArrayList<Project>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project project : projects) {
            translated.add(Translator.translate(project));
        }
        return translated;
    }

    public static Project translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project project) {
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(project);
        return new Project(project.getSpace().getCode(), project.getCode(), registrationDetails);
    }

    public static List<Sample> translateSamples(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> privateSamples) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample privateSample : privateSamples) {
            samples.add(Translator.translate(privateSample));
        }
        return samples;
    }

    public static Sample translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample privateSample) {
        Sample.SampleInitializer initializer = new Sample.SampleInitializer();
        initializer.setId(privateSample.getId());
        initializer.setSpaceCode(privateSample.getSpace() != null ? privateSample.getSpace().getCode() : null);
        initializer.setPermId(privateSample.getPermId());
        initializer.setCode(privateSample.getCode());
        initializer.setIdentifier(privateSample.getIdentifier());
        initializer.setSampleTypeId(privateSample.getSampleType().getId());
        initializer.setSampleTypeCode(privateSample.getSampleType().getCode());
        List<IEntityProperty> properties = privateSample.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        initializer.setRetrievedFetchOptions(EnumSet.of(SampleFetchOption.BASIC, SampleFetchOption.PROPERTIES));
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experimentOrNull = privateSample.getExperiment();
        if (experimentOrNull != null) {
            initializer.setExperimentIdentifierOrNull(experimentOrNull.getIdentifier());
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(privateSample);
        initializer.setRegistrationDetails(registrationDetails);
        return new Sample(initializer);
    }

    public static List<Experiment> translateExperiments(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> privateExperiments) {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExpeiment : privateExperiments) {
            experiments.add(Translator.translate(privateExpeiment));
        }
        return experiments;
    }

    public static Experiment translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment) {
        Experiment.ExperimentInitializer initializer = new Experiment.ExperimentInitializer();
        initializer.setId(privateExperiment.getId());
        initializer.setPermId(privateExperiment.getPermId());
        initializer.setCode(privateExperiment.getCode());
        initializer.setIdentifier(privateExperiment.getIdentifier());
        initializer.setExperimentTypeCode(privateExperiment.getExperimentType().getCode());
        List<IEntityProperty> properties = privateExperiment.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(privateExperiment);
        initializer.setRegistrationDetails(registrationDetails);
        return new Experiment(initializer);
    }

    public static DataSetType translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType privateDataSetType, HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms) {
        DataSetType.DataSetTypeInitializer initializer = new DataSetType.DataSetTypeInitializer();
        initializer.setCode(privateDataSetType.getCode());
        List<DataSetTypePropertyType> dstpts = privateDataSetType.getAssignedPropertyTypes();
        Collections.sort(dstpts);
        String sectionName = null;
        PropertyTypeGroup.PropertyTypeGroupInitializer groupInitializer = new PropertyTypeGroup.PropertyTypeGroupInitializer();
        for (DataSetTypePropertyType dstpt : dstpts) {
            PropertyType.PropertyTypeInitializer ptInitializer;
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType propertyType;
            boolean isControlledVocabulary;
            if (dstpt.isDynamic() || dstpt.isManaged()) continue;
            String thisSectionName = dstpt.getSection();
            if (thisSectionName != null && !thisSectionName.equals(sectionName)) {
                initializer.addPropertyTypeGroup(new PropertyTypeGroup(groupInitializer));
                groupInitializer = new PropertyTypeGroup.PropertyTypeGroupInitializer();
                sectionName = thisSectionName;
            }
            boolean bl = isControlledVocabulary = (propertyType = dstpt.getPropertyType()).getDataType().getCode() == DataTypeCode.CONTROLLEDVOCABULARY;
            if (isControlledVocabulary) {
                ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer cvptInitializer = new ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer();
                cvptInitializer.setVocabulary(propertyType.getVocabulary());
                cvptInitializer.setTerms(vocabTerms.get(propertyType.getVocabulary()));
                ptInitializer = cvptInitializer;
            } else {
                ptInitializer = new PropertyType.PropertyTypeInitializer();
            }
            ptInitializer.setDataType(propertyType.getDataType().getCode());
            ptInitializer.setCode(propertyType.getCode());
            ptInitializer.setLabel(propertyType.getLabel());
            ptInitializer.setDescription(propertyType.getDescription());
            ptInitializer.setMandatory(dstpt.isMandatory());
            if (isControlledVocabulary) {
                groupInitializer.addPropertyType(new ControlledVocabularyPropertyType((ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer)ptInitializer));
                continue;
            }
            groupInitializer.addPropertyType(new PropertyType(ptInitializer));
        }
        initializer.addPropertyTypeGroup(new PropertyTypeGroup(groupInitializer));
        return new DataSetType(initializer);
    }

    public static List<ControlledVocabularyPropertyType.VocabularyTerm> translatePropertyTypeTerms(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<ControlledVocabularyPropertyType.VocabularyTerm> terms = new ArrayList<ControlledVocabularyPropertyType.VocabularyTerm>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm privateTerm : Translator.sortPrivateVocabularyTerms(privateTerms)) {
            EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(privateTerm);
            terms.add(new ControlledVocabularyPropertyType.VocabularyTerm(privateTerm.getCode(), privateTerm.getCodeOrLabel(), privateTerm.getOrdinal(), privateTerm.isOfficial(), registrationDetails));
        }
        return terms;
    }

    public static List<VocabularyTerm> translate(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<VocabularyTerm> terms = new ArrayList<VocabularyTerm>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm privateTerm : Translator.sortPrivateVocabularyTerms(privateTerms)) {
            EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(privateTerm);
            terms.add(new VocabularyTerm(privateTerm.getCode(), privateTerm.getCodeOrLabel(), privateTerm.getOrdinal(), privateTerm.isOfficial(), registrationDetails));
        }
        return terms;
    }

    private static ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> sortPrivateVocabularyTerms(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> sortedTerms = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm>(privateTerms);
        Collections.sort(sortedTerms, new Comparator<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm>(){

            @Override
            public int compare(ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm o1, ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm o2) {
                if (o1.isOfficial() != o2.isOfficial()) {
                    return o1.isOfficial() != false ? -1 : 1;
                }
                return o1.getOrdinal().compareTo(o2.getOrdinal());
            }
        });
        return sortedTerms;
    }

    public static List<DataSet> translate(Iterable<ExternalData> dataSets, EnumSet<DataSet.Connections> connectionsToGet) {
        ArrayList<DataSet> translated = new ArrayList<DataSet>();
        for (ExternalData dataSet : dataSets) {
            translated.add(Translator.translate(dataSet, connectionsToGet));
        }
        return translated;
    }

    public static DataSet translate(ExternalData externalDatum, EnumSet<DataSet.Connections> connectionsToGet) {
        DataSet.DataSetInitializer initializer = new DataSet.DataSetInitializer();
        initializer.setCode(externalDatum.getCode());
        initializer.setExperimentIdentifier(externalDatum.getExperiment().getIdentifier());
        initializer.setSampleIdentifierOrNull(externalDatum.getSampleIdentifier());
        initializer.setDataSetTypeCode(externalDatum.getDataSetType().getCode());
        List<IEntityProperty> properties = externalDatum.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        initializer.setContainerDataSet(externalDatum.isContainer());
        if (externalDatum.isContainer()) {
            ContainerDataSet containerDataSet = externalDatum.tryGetAsContainerDataSet();
            ArrayList<DataSet> containedDataSetCodes = new ArrayList<DataSet>(containerDataSet.getContainedDataSets().size());
            for (ExternalData containedDataSet : containerDataSet.getContainedDataSets()) {
                containedDataSetCodes.add(Translator.translate(containedDataSet, connectionsToGet));
            }
            initializer.setContainedDataSets(containedDataSetCodes);
        }
        initializer.setRetrievedConnections(connectionsToGet);
        for (DataSet.Connections connection : connectionsToGet) {
            switch (connection) {
                case PARENTS: {
                    Collection<ExternalData> parents = externalDatum.getParents();
                    ArrayList<String> parentCodes = new ArrayList<String>();
                    for (ExternalData parentDatum : CollectionUtils.nullSafe(parents)) {
                        parentCodes.add(parentDatum.getCode());
                    }
                    initializer.setParentCodes(parentCodes);
                    break;
                }
                case CHILDREN: {
                    List<ExternalData> children = externalDatum.getChildren();
                    ArrayList<String> childrenCodes = new ArrayList<String>();
                    for (ExternalData parentDatum : CollectionUtils.nullSafe(children)) {
                        childrenCodes.add(parentDatum.getCode());
                    }
                    initializer.setChildrenCodes(childrenCodes);
                }
            }
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(externalDatum);
        initializer.setRegistrationDetails(registrationDetails);
        return new DataSet(initializer);
    }

    private static EntityRegistrationDetails translateRegistrationDetails(CodeWithRegistration<?> thingWithRegistrationDetails) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = Translator.createInitializer(thingWithRegistrationDetails);
        return new EntityRegistrationDetails(initializer);
    }

    private static EntityRegistrationDetails translateRegistrationDetailsWithModificationDate(CodeWithRegistrationAndModificationDate<?> thingWithRegistrationDetails) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = Translator.createInitializer(thingWithRegistrationDetails);
        initializer.setModificationDate(thingWithRegistrationDetails.getModificationDate());
        return new EntityRegistrationDetails(initializer);
    }

    private static EntityRegistrationDetails.EntityRegistrationDetailsInitializer createInitializer(CodeWithRegistration<?> thingWithRegistrationDetails) {
        Person registrator = thingWithRegistrationDetails.getRegistrator();
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        if (registrator != null) {
            initializer.setEmail(registrator.getEmail());
            initializer.setFirstName(registrator.getFirstName());
            initializer.setLastName(registrator.getLastName());
            initializer.setUserId(registrator.getUserId());
        }
        initializer.setRegistrationDate(thingWithRegistrationDetails.getRegistrationDate());
        return initializer;
    }

    private Translator() {
    }

    public static Vocabulary translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary) {
        Vocabulary.VocabularyInitializer initializer = new Vocabulary.VocabularyInitializer();
        initializer.setId(privateVocabulary.getId());
        initializer.setCode(privateVocabulary.getCode());
        initializer.setDescription(privateVocabulary.getDescription());
        initializer.setChosenFromList(privateVocabulary.isChosenFromList());
        initializer.setInternalNamespace(privateVocabulary.isInternalNamespace());
        initializer.setManagedInternally(privateVocabulary.isManagedInternally());
        initializer.setUrlTemplate(privateVocabulary.getURLTemplate());
        initializer.setTerms(Translator.translate(privateVocabulary.getTerms()));
        return new Vocabulary(initializer);
    }

    public static Material translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material, Map<Long, Material> materialsCache) {
        Material.MaterialInitializer mi = new Material.MaterialInitializer();
        mi.setMaterialCode(material.getCode());
        MaterialTypeIdentifier typeIdentifier = new MaterialTypeIdentifier(material.getMaterialType().getCode());
        mi.setMaterialTypeIdentifier(typeIdentifier);
        material.getProperties();
        List<IEntityProperty> originalProperties = material.getProperties();
        Map properties = EntityHelper.convertToStringMap(originalProperties);
        Map<String, Material> materialProperties = Translator.convertMaterialProperties(originalProperties, materialsCache);
        mi.setMaterialProperties(materialProperties);
        mi.setProperties(properties);
        mi.setRegistrationDetails(Translator.translateRegistrationDetails(material));
        return new Material(mi);
    }

    private static Map<String, Material> convertMaterialProperties(List<IEntityProperty> properties, Map<Long, Material> materialsCache) {
        HashMap<String, Material> result = new HashMap<String, Material>();
        if (properties != null) {
            for (IEntityProperty property : properties) {
                ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material = property.getMaterial();
                if (material == null) continue;
                Material apiMaterial = materialsCache.get(material.getId());
                if (apiMaterial == null) {
                    apiMaterial = Translator.translate(material, materialsCache);
                }
                String propCode = property.getPropertyType().getCode();
                result.put(propCode, apiMaterial);
            }
        }
        return result;
    }

    public static List<Material> translateMaterials(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials) {
        HashMap<Long, Material> materialsCache = new HashMap<Long, Material>();
        LinkedList<Material> list = new LinkedList<Material>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material : materials) {
            list.add(Translator.translate(material, materialsCache));
        }
        return list;
    }
}

