/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonObject(value="TechId")
public class TechId
implements IIdHolder,
Serializable {
    private static final long serialVersionUID = 32L;
    private Long id;

    public TechId() {
    }

    public TechId(Long id) {
        assert (id != null) : "id cannot be null";
        this.id = id;
    }

    public TechId(Number id) {
        assert (id != null) : "id cannot be null";
        this.id = id.longValue();
    }

    public TechId(IIdAndCodeHolder identifiable) {
        this(identifiable.getId());
    }

    public static TechId create(IIdHolder idHolder) {
        if (idHolder == null || idHolder.getId() == null) {
            return null;
        }
        return new TechId(idHolder.getId());
    }

    public static List<TechId> createList(long ... ids) {
        ArrayList<TechId> result = new ArrayList<TechId>();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            result.add(new TechId(id));
            ++n2;
        }
        return result;
    }

    public static List<TechId> createList(List<Long> ids) {
        ArrayList<TechId> result = new ArrayList<TechId>();
        for (Long id : ids) {
            result.add(new TechId(id));
        }
        return result;
    }

    public static List<TechId> createList(Collection<? extends IIdHolder> idHolders) {
        ArrayList<TechId> results = new ArrayList<TechId>();
        for (IIdHolder iIdHolder : idHolders) {
            results.add(TechId.create(iIdHolder));
        }
        return results;
    }

    public static List<Long> asLongs(Collection<TechId> techIds) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (TechId techId : techIds) {
            results.add(techId.getId());
        }
        return results;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TechId)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public static TechId createWildcardTechId() {
        return new WildcardTechId();
    }

    @JsonObject(value="WildcardTechId")
    private static class WildcardTechId
    extends TechId {
        private static final long serialVersionUID = 32L;

        @Override
        public String toString() {
            return ".*";
        }
    }
}

