/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.io.Serializable;

public class EntityReference
implements Serializable,
IEntityInformationHolderWithPermId {
    private static final long serialVersionUID = 32L;
    private long id;
    private String code;
    private String typeCode;
    private EntityKind kind;
    private String permIdOrNull;

    protected EntityReference() {
    }

    public EntityReference(long id, String code, String typeCode, EntityKind kind, String permIdOrNull) {
        assert (permIdOrNull != null || kind == EntityKind.MATERIAL) : "perm id can be null only for a material";
        this.id = id;
        this.code = code;
        this.typeCode = typeCode;
        this.kind = kind;
        this.permIdOrNull = permIdOrNull;
    }

    @Override
    public EntityKind getEntityKind() {
        return this.kind;
    }

    @Override
    public BasicEntityType getEntityType() {
        return new BasicEntityType(this.typeCode);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.kind + " " + this.code + " (" + this.typeCode + ")";
    }

    @Override
    public String getPermId() {
        return this.permIdOrNull;
    }
}

