/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.base.exceptions.StopException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class ThreadGuard {
    private final Lock stopLock = new ReentrantLock();
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private Thread thread;
    private State state = State.INITIAL;
    private volatile boolean cancelled = false;

    ThreadGuard() {
    }

    private static void stopNow(Thread t) {
        t.stop((Throwable)new StopException());
    }

    private boolean stop(Thread t, long timeoutMillis) throws InterruptedException {
        boolean gotIt = this.stopLock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
        if (this.waitForFinished(0L)) {
            return true;
        }
        if (!gotIt) {
            return false;
        }
        try {
            ThreadGuard.stopNow(t);
            return true;
        }
        finally {
            this.stopLock.unlock();
        }
    }

    private synchronized Thread tryInterruptAndGetThread() {
        if (this.state == State.RUNNING) {
            Thread t = this.thread;
            this.thread = null;
            this.state = State.TERMINATING;
            t.interrupt();
            return t;
        }
        return null;
    }

    void preventStopping() {
        this.stopLock.lock();
    }

    void allowStopping() {
        this.stopLock.unlock();
    }

    void markFinished() {
        this.finishedLatch.countDown();
        this.stopLock.unlock();
    }

    boolean waitForFinished(long timeoutMillis) throws InterruptedException {
        return this.finishedLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    synchronized boolean startGuard() {
        if (this.state != State.INITIAL) {
            return false;
        }
        this.stopLock.lock();
        this.state = State.RUNNING;
        this.thread = Thread.currentThread();
        return true;
    }

    synchronized void shutdownGuard() {
        this.state = State.FINISHING;
        this.thread = null;
        Thread.interrupted();
    }

    synchronized boolean hasStarted() {
        return this.state != State.INITIAL && this.state != State.CANCELED;
    }

    synchronized boolean isRunning() {
        return this.state == State.RUNNING;
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.state == State.INITIAL) {
            this.state = State.CANCELED;
            this.finishedLatch.countDown();
            this.cancelled = true;
        } else {
            this.cancelled = mayInterruptIfRunning ? this.tryInterruptAndGetThread() != null : false;
        }
        return this.cancelled;
    }

    boolean terminateAndWait(long waitInterruptMillis, long timeoutMillis) throws InterruptedException {
        if (this.cancel(false)) {
            return true;
        }
        long start = System.currentTimeMillis();
        Thread t = this.tryInterruptAndGetThread();
        if (t != null) {
            this.cancelled = true;
            if (this.waitForFinished(waitInterruptMillis)) {
                return true;
            }
            if (!this.stop(t, timeoutMillis - (System.currentTimeMillis() - start))) {
                return false;
            }
        }
        return this.waitForFinished(timeoutMillis - (System.currentTimeMillis() - start));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        CANCELED,
        TERMINATING,
        RUNNING,
        FINISHING;

    }
}

