/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.DirectoryScannedStore;
import ch.systemsx.cisd.common.filesystem.FaultyPathDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.IDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.IPathHandler;
import ch.systemsx.cisd.common.filesystem.IStoreHandler;
import ch.systemsx.cisd.common.filesystem.PathHandlerAdapter;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.logging.ConditionalNotificationLogger;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ITimerTaskStatusProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DirectoryScanningTimerTask
extends TimerTask
implements ITimerTaskStatusProvider {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DirectoryScanningTimerTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DirectoryScanningTimerTask.class);
    private final IStoreHandler storeHandler;
    private final IScannedStore sourceDirectory;
    private final IDirectoryScanningHandler directoryScanningHandler;
    private final ConditionalNotificationLogger notificationLogger;
    private final Map<StoreItem, String> errorLog;
    private boolean didSomeWork;
    private String threadNameOrNull;
    private volatile boolean stopRun;

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler handler, IDirectoryScanningHandler directoryScanningHandler) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), directoryScanningHandler, PathHandlerAdapter.asScanningHandler(sourceDirectory, handler), 0);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IStoreHandler storeHandler, IDirectoryScanningHandler directoryScanningHandler) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), directoryScanningHandler, storeHandler, 0);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler pathHandler) {
        this(sourceDirectory, filter, pathHandler, 0);
    }

    public DirectoryScanningTimerTask(IScannedStore scannedStore, IDirectoryScanningHandler directoryScanningHandler, IStoreHandler storeHandler, int ignoredErrorCount) {
        assert (scannedStore != null);
        assert (storeHandler != null);
        assert (directoryScanningHandler != null) : "Unspecified IDirectoryScanningHandler implementation";
        assert (ignoredErrorCount >= 0);
        this.sourceDirectory = scannedStore;
        this.storeHandler = storeHandler;
        this.directoryScanningHandler = directoryScanningHandler;
        this.notificationLogger = new ConditionalNotificationLogger(operationLog, (Priority)Level.WARN, notificationLog, ignoredErrorCount);
        this.errorLog = new LinkedHashMap<StoreItem, String>();
    }

    DirectoryScanningTimerTask(File sourceDirectory, FileFilter fileFilter, IPathHandler pathHandler, int ignoredErrorCount) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, fileFilter), new FaultyPathDirectoryScanningHandler(sourceDirectory, pathHandler), PathHandlerAdapter.asScanningHandler(sourceDirectory, pathHandler), ignoredErrorCount);
    }

    private static final IScannedStore asScannedStore(File directory, FileFilter filter) {
        return new DirectoryScannedStore(filter, directory);
    }

    private final void printNotification(Exception ex) {
        if (ex instanceof TimeoutExceptionUnchecked) {
            notificationLog.error((Object)("Timeout while scanning directory: " + ex.getMessage()), (Throwable)ex);
        } else {
            notificationLog.error((Object)"An exception has occurred. (thread still running)", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }

    private final StoreItem[] listStoreItems() {
        StoreItem[] storeItems = this.sourceDirectory.tryListSorted(this.notificationLogger);
        if (storeItems != null) {
            this.notificationLogger.reset(String.format("Directory '%s' is available again.", this.sourceDirectory));
        }
        return storeItems == null ? StoreItem.EMPTY_ARRAY : storeItems;
    }

    public final void stopRun() {
        this.stopRun = true;
    }

    public final void run() {
        block29: {
            if (operationLog.isTraceEnabled()) {
                operationLog.trace((Object)String.format("Start scanning directory '%s'.", this.sourceDirectory));
            }
            this.threadNameOrNull = Thread.currentThread().getName();
            try {
                int numberOfItemsProcessedInLastRound;
                this.didSomeWork = false;
                this.directoryScanningHandler.init(this.sourceDirectory);
                block8: do {
                    numberOfItemsProcessedInLastRound = 0;
                    StoreItem[] allStoreItems = this.listStoreItems();
                    if (operationLog.isTraceEnabled()) {
                        operationLog.trace((Object)String.format("Found %d store items in total.", allStoreItems.length));
                    }
                    this.cleanseErrorLog(allStoreItems);
                    if (operationLog.isTraceEnabled()) {
                        operationLog.trace((Object)String.format("Found %d store items that are not in error state.", allStoreItems.length));
                    }
                    Object[] storeItemsOrNull = this.sourceDirectory.tryFilterReadyToProcess(allStoreItems, this.notificationLogger);
                    if (operationLog.isTraceEnabled()) {
                        operationLog.trace((Object)String.format("Found %d store items ready to be processed.", storeItemsOrNull == null ? 0 : storeItemsOrNull.length));
                    }
                    if (storeItemsOrNull == null) break;
                    int numberOfItems = storeItemsOrNull.length;
                    this.directoryScanningHandler.beforeHandle(this.sourceDirectory);
                    if (operationLog.isTraceEnabled()) {
                        operationLog.trace((Object)"beforeHandle() completed.");
                    }
                    int i = 0;
                    while (i < numberOfItems) {
                        block30: {
                            StoreItem storeItem = storeItemsOrNull[i];
                            if (operationLog.isTraceEnabled()) {
                                operationLog.trace((Object)String.format("Looping over store item '%s'.", storeItem));
                            }
                            if (this.stopRun || Thread.interrupted() || this.storeHandler.isStopped()) {
                                if (operationLog.isDebugEnabled()) {
                                    operationLog.debug((Object)String.format("Scan of store '%s' has been cancelled. Following items have NOT been handled: %s.", this.sourceDirectory, CollectionUtils.abbreviate(ArrayUtils.subarray((Object[])storeItemsOrNull, (int)(i + 1), (int)numberOfItems), 10)));
                                }
                                return;
                            }
                            IDirectoryScanningHandler.HandleInstruction instruction = this.directoryScanningHandler.mayHandle(this.sourceDirectory, storeItem);
                            if (operationLog.isTraceEnabled()) {
                                if (instruction.tryGetMessage() == null) {
                                    operationLog.trace((Object)String.format("Handle instruction: %s.", new Object[]{instruction.getFlag()}));
                                } else {
                                    operationLog.trace((Object)String.format("Handle instruction: %s [%s].", new Object[]{instruction.getFlag(), instruction.tryGetMessage()}));
                                }
                            }
                            if (IDirectoryScanningHandler.HandleInstructionFlag.PROCESS.equals((Object)instruction.getFlag())) {
                                String msgOrNull;
                                Status status;
                                try {
                                    this.storeHandler.handle(storeItem);
                                    if (operationLog.isTraceEnabled()) {
                                        operationLog.trace((Object)String.format("Store item '%s' has been handled.", storeItem));
                                    }
                                    this.didSomeWork = true;
                                    ++numberOfItemsProcessedInLastRound;
                                }
                                catch (Exception ex) {
                                    if (ex instanceof InterruptedExceptionUnchecked) {
                                        status = this.directoryScanningHandler.finishItemHandle(this.sourceDirectory, storeItem);
                                        if (!status.isError()) continue block8;
                                        msgOrNull = status.tryGetErrorMessage();
                                        this.errorLog.put(storeItem, StringUtils.defaultIfEmpty((String)msgOrNull, (String)this.getDefaultErrorMessage(storeItem)));
                                        continue block8;
                                    }
                                    try {
                                        this.errorLog.put(storeItem, String.format("Exception when processing item '%s': %s (%s)", storeItem, ex.getClass().getSimpleName(), StringUtils.defaultString((String)ex.getMessage(), (String)"no message")));
                                        this.printNotification(ex);
                                        break block30;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        status = this.directoryScanningHandler.finishItemHandle(this.sourceDirectory, storeItem);
                                        if (status.isError()) {
                                            msgOrNull = status.tryGetErrorMessage();
                                            this.errorLog.put(storeItem, StringUtils.defaultIfEmpty((String)msgOrNull, (String)this.getDefaultErrorMessage(storeItem)));
                                        }
                                    }
                                }
                                status = this.directoryScanningHandler.finishItemHandle(this.sourceDirectory, storeItem);
                                if (!status.isError()) break block30;
                                msgOrNull = status.tryGetErrorMessage();
                                this.errorLog.put(storeItem, StringUtils.defaultIfEmpty((String)msgOrNull, (String)this.getDefaultErrorMessage(storeItem)));
                            } else {
                                if (IDirectoryScanningHandler.HandleInstructionFlag.ERROR.equals((Object)instruction.getFlag())) {
                                    String msgOrNull = instruction.tryGetMessage();
                                    this.errorLog.put(storeItem, StringUtils.defaultIfEmpty((String)msgOrNull, (String)this.getDefaultErrorMessage(storeItem)));
                                }
                                if (operationLog.isTraceEnabled()) {
                                    operationLog.trace((Object)String.format("Following store item '%s' has NOT been handled (%s).", storeItem, instruction));
                                }
                            }
                        }
                        ++i;
                    }
                } while (numberOfItemsProcessedInLastRound > 0);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedExceptionUnchecked) break block29;
                this.printNotification(ex);
            }
        }
        if (operationLog.isTraceEnabled()) {
            operationLog.trace((Object)String.format("Finished scanning directory '%s'.", this.sourceDirectory));
        }
    }

    private void cleanseErrorLog(StoreItem[] allStoreItemsOrNull) {
        if (allStoreItemsOrNull == null) {
            return;
        }
        HashSet<StoreItem> itemSet = new HashSet<StoreItem>(Arrays.asList(allStoreItemsOrNull));
        for (StoreItem errorItem : new ArrayList<StoreItem>(this.errorLog.keySet())) {
            if (itemSet.contains(errorItem)) continue;
            this.errorLog.remove(errorItem);
        }
    }

    private String getDefaultErrorMessage(StoreItem storeItem) {
        return String.format("Error processing item '%s'.", storeItem);
    }

    public boolean hasErrors() {
        return this.errorLog.size() > 0;
    }

    public boolean hasPerformedMeaningfulWork() {
        return this.didSomeWork;
    }

    public String tryGetErrorLog() {
        if (this.hasErrors()) {
            return String.format("  [%s]\n  %s", StringUtils.defaultIfEmpty((String)this.threadNameOrNull, (String)"UNKNOWN"), StringUtils.join(this.errorLog.values(), (String)"\n  "));
        }
        return null;
    }

    public static interface IScannedStore {
        public StoreItem[] tryListSorted(ISimpleLogger var1);

        public StoreItem[] tryFilterReadyToProcess(StoreItem[] var1, ISimpleLogger var2);

        public boolean existsOrError(StoreItem var1);

        public String getLocationDescription(StoreItem var1);

        public StoreItem asStoreItem(String var1);
    }
}

