/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLinkMaker {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SoftLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, SoftLinkMaker.class);
    private final File lnExec = OSUtilities.findExecutable((String)"ln");

    private SoftLinkMaker() {
        if (this.lnExec == null) {
            throw new IllegalStateException("Linking command not found");
        }
    }

    private final List<String> createCommand(File sourceFile, File targetDir) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.lnExec.getAbsolutePath());
        tokens.add("-sf");
        tokens.add(sourceFile.getAbsolutePath());
        tokens.add(targetDir.getAbsolutePath());
        return tokens;
    }

    public static boolean createSymbolicLink(File sourceFile, File targetDirOrFile) {
        return ProcessExecutionHelper.runAndLog(new SoftLinkMaker().createCommand(sourceFile, targetDirOrFile), operationLog, machineLog);
    }
}

