/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.ByteBufferRandomAccessFile;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayBasedContentNode
implements IHierarchicalContentNode {
    private final byte[] byteArray;
    private final String nameOrNull;
    private long lastModified;

    public ByteArrayBasedContentNode(byte[] byteArray, String nameOrNull) {
        this.byteArray = byteArray;
        this.nameOrNull = nameOrNull;
        this.lastModified = new Date().getTime();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray);
    }

    @Override
    public String getName() {
        return this.nameOrNull;
    }

    @Override
    public String getRelativePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getParentRelativePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFileLength() throws UnsupportedOperationException {
        return this.byteArray.length;
    }

    @Override
    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return new ByteBufferRandomAccessFile(ByteBuffer.wrap(this.byteArray));
    }
}

