/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import java.util.HashSet;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer {
    private static final String DEFAULT_PLACEHOLDER_RESOLVER_MODE = "SYSTEM_PROPERTIES_MODE_FALLBACK";
    private String systemPropertiesModePlaceholder;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    private final String cleanPropertyKey(String propertyKey) {
        return propertyKey.substring(this.placeholderPrefix.length(), propertyKey.length() - this.placeholderSuffix.length());
    }

    protected final String convertPropertyValue(String originalValue) {
        return StringUtils.trimWhitespace((String)originalValue);
    }

    protected final void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        String resolvedPlaceholder = null;
        if (this.systemPropertiesModePlaceholder != null) {
            try {
                resolvedPlaceholder = this.parseStringValue(this.systemPropertiesModePlaceholder, props, new HashSet());
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {}
        }
        if (resolvedPlaceholder == null || resolvedPlaceholder.equals(this.systemPropertiesModePlaceholder)) {
            resolvedPlaceholder = DEFAULT_PLACEHOLDER_RESOLVER_MODE;
        }
        super.setSystemPropertiesModeName(resolvedPlaceholder);
        if (this.systemPropertiesModePlaceholder != null) {
            props.setProperty(this.cleanPropertyKey(this.systemPropertiesModePlaceholder), resolvedPlaceholder);
        }
        super.processProperties(beanFactoryToProcess, props);
    }

    public final void setSystemPropertiesModeName(String placeHolder) throws IllegalArgumentException {
        this.systemPropertiesModePlaceholder = placeHolder;
    }

    public final void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        super.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        super.setPlaceholderSuffix(placeholderSuffix);
    }
}

