/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.rinn.restrictions.Private;
import org.apache.commons.lang.StringUtils;

public final class Message {
    @Private
    static final String XML_MESSAGE_TEMPLATE = "<message type=\"%s\">%s</message>";
    @Private
    static final String XML_MESSAGE_WITH_CDATA_TEMPLATE = "<message type=\"%s\"><![CDATA[%s]]></message>";
    private final Type type;
    private final String messageText;

    public Message(Type type, String messageText) {
        assert (type != null) : "Unspecified type.";
        assert (messageText != null) : "Unspecified message text.";
        this.type = type;
        this.messageText = messageText;
    }

    public static final Message createInfoMessage(String messageText) {
        return new Message(Type.INFO, messageText);
    }

    public static final Message createWarnMessage(String messageText) {
        return new Message(Type.WARN, messageText);
    }

    public static final Message createErrorMessage(String messageText) {
        return new Message(Type.ERROR, messageText);
    }

    public final String toXml() {
        if (StringUtils.containsAny((String)this.messageText, (String)"&<")) {
            return String.format(XML_MESSAGE_WITH_CDATA_TEMPLATE, this.type.getLabel(), this.messageText);
        }
        return String.format(XML_MESSAGE_TEMPLATE, this.type.getLabel(), this.messageText);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        ERROR("error"),
        WARN("warning"),
        INFO("info");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public final String getLabel() {
            return this.label;
        }
    }
}

