/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelFileReader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ExcelFileReader.class);
    private final boolean ignoreComments;
    private final Workbook workbook;
    private static final String COMMENT = "#";

    public ExcelFileReader(Workbook workbook, boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        this.workbook = workbook;
    }

    public List<String[]> readLines() throws IOException {
        Sheet sheet = this.workbook.getSheetAt(0);
        return ExcelFileReader.loadLines(sheet, this.ignoreComments);
    }

    public List<String[]> readLines(int sheetIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIndex);
        return ExcelFileReader.loadLines(sheet, this.ignoreComments);
    }

    public List<String[]> readLines(String sheetName) throws IOException {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new UserFailureException("Couldn't find sheet named " + sheetName);
        }
        return ExcelFileReader.loadLines(sheet, this.ignoreComments);
    }

    public static boolean isExcelFile(File file) {
        return FilenameUtils.isExtension((String)file.getName().toLowerCase(), (String[])new String[]{"xls", "xlsx"});
    }

    public static Workbook getExcelWorkbook(File file) throws IOException, IllegalArgumentException {
        String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        FileInputStream stream = new FileInputStream(file);
        try {
            if ("xls".equals(extension)) {
                POIFSFileSystem poifsFileSystem = new POIFSFileSystem((InputStream)stream);
                HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(poifsFileSystem);
                return hSSFWorkbook;
            }
            if ("xlsx".equals(extension)) {
                XSSFWorkbook xSSFWorkbook = new XSSFWorkbook((InputStream)stream);
                return xSSFWorkbook;
            }
            throw new IllegalArgumentException("Expected an Excel file with 'xls' or 'xlsx' extension, got " + file.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static boolean isComment(Row row) {
        return row.getCell(0) != null && row.getCell(0).toString().startsWith(COMMENT);
    }

    private static List<String[]> loadLines(Sheet sheet, boolean ignoreComments) throws IOException {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        int headerSize = ExcelFileReader.extractMaxColumnIndex(sheet) + 1;
        for (Row row : sheet) {
            if (ignoreComments && ExcelFileReader.isComment(row)) continue;
            String[] line = new String[headerSize];
            for (Cell cell : row) {
                String value = ExcelFileReader.extractCellValue(cell);
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug((Object)(String.valueOf(ExcelFileReader.extractCellPosition(cell)) + ": " + value));
                }
                line[cell.getColumnIndex()] = value;
            }
            lines.add(line);
        }
        if (operationLog.isDebugEnabled()) {
            for (Object[] objectArray : lines) {
                operationLog.debug((Object)Arrays.toString(objectArray));
            }
        }
        return lines;
    }

    private static int extractMaxColumnIndex(Sheet sheet) {
        int maxIndex = 0;
        for (Row row : sheet) {
            maxIndex = Math.max(maxIndex, ExcelFileReader.extractMaxColumnIndex(row));
        }
        return maxIndex;
    }

    private static int extractMaxColumnIndex(Row row) {
        int maxColumnIndex = 0;
        for (Cell cell : row) {
            maxColumnIndex = Math.max(maxColumnIndex, cell.getColumnIndex());
        }
        return maxColumnIndex;
    }

    private static String extractCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 3: {
                return "BLANK";
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 0: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                throw new UserFailureException("Excel formulas are not supported but one was found in cell " + ExcelFileReader.extractCellPosition(cell));
            }
            case 5: {
                throw new UserFailureException("There is an error in cell " + ExcelFileReader.extractCellPosition(cell));
            }
        }
        throw new UserFailureException("Unknown data type of cell " + ExcelFileReader.extractCellPosition(cell));
    }

    private static String extractCellPosition(Cell cell) {
        String col = CellReference.convertNumToColString((int)cell.getColumnIndex());
        String row = "" + (cell.getRowIndex() + 1);
        return String.valueOf(col) + row;
    }

    public static void main(String[] args) throws Exception {
        String filename = "/Users/kaloyane/cisd/train-tasks/2011-07-08-LIMBUD/Sample_template_modified.xlsx";
        File file = new File(filename);
        Workbook wb = ExcelFileReader.getExcelWorkbook(file);
        ExcelFileReader helper = new ExcelFileReader(wb, false);
        List<String[]> lines = helper.readLines();
        for (Object[] objectArray : lines) {
            System.err.println(Arrays.toString(objectArray));
        }
    }
}

