/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;

public class ImageTableCell
implements ISerializableComparable {
    private static final long serialVersionUID = 32L;
    private static final String SLASH = "/";
    private String path;
    private int maxThumbnailWidth;
    private int maxThumbnailHeight;

    private static String getPath(String dataSetCode, String dataSetLocation, String originalPath) {
        int indexOfLocation = originalPath.indexOf(dataSetLocation);
        if (indexOfLocation < 0) {
            throw new IllegalArgumentException("Data set location '" + dataSetLocation + "' inconsistent with original path: " + originalPath);
        }
        String relativePath = originalPath.substring(indexOfLocation + dataSetLocation.length());
        return ImageTableCell.getPath(dataSetCode, relativePath);
    }

    private static String getPath(String dataSetCode, String relativePath) {
        String delimiter = "";
        if (!relativePath.startsWith(SLASH)) {
            delimiter = SLASH;
        }
        return String.valueOf(dataSetCode) + delimiter + relativePath;
    }

    public ImageTableCell(String dataSetCode, String dataSetLocation, String originalPath, int maxThumbnailWidth, int maxThumbnailHeight) {
        this(ImageTableCell.getPath(dataSetCode, dataSetLocation, originalPath), maxThumbnailWidth, maxThumbnailHeight);
    }

    public ImageTableCell(String dataSetCode, String relativePathFromDataSetRoot, int maxThumbnailWidth, int maxThumbnailHeight) {
        this(ImageTableCell.getPath(dataSetCode, relativePathFromDataSetRoot), maxThumbnailWidth, maxThumbnailHeight);
    }

    public ImageTableCell(String path, int maxThumbnailWidth, int maxThumbnailHeight) {
        this.path = path;
        this.maxThumbnailWidth = maxThumbnailWidth;
        this.maxThumbnailHeight = maxThumbnailHeight;
    }

    public String getPath() {
        return this.path;
    }

    public int getMaxThumbnailWidth() {
        return this.maxThumbnailWidth;
    }

    public int getMaxThumbnailHeight() {
        return this.maxThumbnailHeight;
    }

    public int compareTo(ISerializableComparable o) {
        return this.toString().compareTo(String.valueOf(o));
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ImageTableCell && ((ImageTableCell)obj).path.equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private ImageTableCell() {
    }
}

