/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.utilities.ClassUtils;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class EntityTypePropertyTypePE
extends HibernateAbstractRegistrationHolder
implements IEntityTypePropertyType,
Comparable<EntityTypePropertyTypePE> {
    private static final long serialVersionUID = 32L;
    private boolean mandatory;
    private boolean managedInternally;
    private Long ordinal;
    private String section;
    protected transient Long id;
    protected EntityTypePE entityType;
    protected Set<EntityPropertyPE> propertyValues;
    private PropertyTypePE propertyType;
    private ScriptPE script;
    private boolean shownInEditView;

    public static final <T extends EntityTypePropertyTypePE> T createEntityTypePropertyType(EntityKind entityKind) {
        return (T)((EntityTypePropertyTypePE)ClassUtils.createInstance(entityKind.getEntityTypePropertyTypeAssignmentClass()));
    }

    @NotNull(message="Property type can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="prty_id", updatable=false)
    private PropertyTypePE getPropertyTypeInternal() {
        return this.propertyType;
    }

    @Transient
    public PropertyTypePE getPropertyType() {
        return this.getPropertyTypeInternal();
    }

    void setPropertyTypeInternal(PropertyTypePE propertyType) {
        this.propertyType = propertyType;
    }

    public abstract void setPropertyType(PropertyTypePE var1);

    private void setPropertyValues(Set<EntityPropertyPE> propertyValues) {
        this.propertyValues = propertyValues;
    }

    @Transient
    public boolean isScriptable() {
        return this.getScript() != null;
    }

    @Transient
    public boolean isDynamic() {
        return this.isScriptable() && this.getScript().isDynamic();
    }

    @Transient
    public boolean isManaged() {
        return this.isScriptable() && this.getScript().isManaged();
    }

    @NotNull
    @Column(name="is_shown_edit", updatable=true)
    public boolean isShownInEditView() {
        return this.shownInEditView;
    }

    public void setShownInEditView(boolean shownInEditView) {
        this.shownInEditView = shownInEditView;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="script_id", updatable=true)
    public ScriptPE getScript() {
        return this.script;
    }

    public void setScript(ScriptPE script) {
        this.script = script;
    }

    @NotNull
    @Column(name="is_mandatory", updatable=true)
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @NotNull
    @Column(name="is_managed_internally")
    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    @Column(name="ordinal")
    @NotNull(message="Ordinal can not be null.")
    public Long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    @Column(name="section")
    @Length(max=2000, message="Given section '%s' is too long (maximal length: {max} characters).")
    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    void setEntityTypeInternal(EntityTypePE entityType) {
        this.entityType = entityType;
    }

    public void setEntityType(EntityTypePE entityType) {
        this.setEntityTypeInternal(entityType);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("managedInternally", this.isManagedInternally());
        builder.append("mandatory", this.isMandatory());
        builder.append("propertyType", (Object)this.getPropertyType());
        builder.append("entityType", (Object)this.getEntityType());
        builder.append("ordinal", (Object)this.getOrdinal());
        builder.append("section", (Object)this.getSection());
        builder.append("dynamic", this.isDynamic());
        builder.append("managed", this.isManaged());
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityTypePropertyTypePE)) {
            return false;
        }
        EntityTypePropertyTypePE that = (EntityTypePropertyTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getPropertyType(), (Object)that.getPropertyType());
        builder.append((Object)this.getEntityType(), (Object)that.getEntityType());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getPropertyType());
        builder.append((Object)this.getEntityType());
        return builder.toHashCode();
    }

    @Override
    public int compareTo(EntityTypePropertyTypePE o) {
        return this.getOrdinal().compareTo(o.getOrdinal());
    }
}

