/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.collections.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="samples")
@Check(constraints="(dbin_id IS NOT NULL AND space_id IS NULL) OR (dbin_id IS NULL AND space_id IS NOT NULL)")
@Indexed(index="SamplePE")
public class SamplePE
extends AttachmentHolderPE
implements IIdAndCodeHolder,
Comparable<SamplePE>,
IEntityInformationWithPropertiesHolder,
IMatchingEntity,
IDeletablePE,
Serializable {
    private static final long serialVersionUID = 32L;
    public static final SamplePE[] EMPTY_ARRAY = new SamplePE[0];
    public static final List<SamplePE> EMPTY_LIST = Collections.emptyList();
    private Long id;
    private String code;
    private SampleTypePE sampleType;
    private DatabaseInstancePE databaseInstance;
    private SpacePE space;
    private SampleIdentifier sampleIdentifier;
    private SamplePE container;
    private ExperimentPE experiment;
    private String permId;
    private Set<SampleRelationshipPE> parentRelationships = new HashSet<SampleRelationshipPE>();
    private Set<SampleRelationshipPE> childRelationships = new HashSet<SampleRelationshipPE>();
    private DeletionPE deletion;
    private Set<SamplePropertyPE> properties = new HashSet<SamplePropertyPE>();
    private PersonPE registrator;
    private Date registrationDate;
    private Date modificationDate;
    private Set<DataPE> datasets = new HashSet<DataPE>();
    private List<SamplePE> contained = new ArrayList<SamplePE>();

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentSample")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<SampleRelationshipPE> getSampleChildRelationships() {
        return this.childRelationships;
    }

    private void setSampleChildRelationships(Set<SampleRelationshipPE> childRelationships) {
        this.childRelationships = childRelationships;
    }

    @Transient
    public Set<SampleRelationshipPE> getChildRelationships() {
        return new UnmodifiableSetDecorator<SampleRelationshipPE>(this.getSampleChildRelationships());
    }

    @Transient
    public boolean isChildRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getSampleChildRelationships());
    }

    public void addChildRelationship(SampleRelationshipPE relationship) {
        relationship.setParentSample(this);
        this.getSampleChildRelationships().add(relationship);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="childSample")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<SampleRelationshipPE> getSampleParentRelationships() {
        return this.parentRelationships;
    }

    private void setSampleParentRelationships(Set<SampleRelationshipPE> parentRelationships) {
        this.parentRelationships = parentRelationships;
    }

    @Transient
    public Set<SampleRelationshipPE> getParentRelationships() {
        return new UnmodifiableSetDecorator<SampleRelationshipPE>(this.getSampleParentRelationships());
    }

    @Transient
    public boolean isParentRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getSampleParentRelationships());
    }

    public void setParentRelationships(Set<SampleRelationshipPE> parentRelationships) {
        this.getSampleParentRelationships().clear();
        for (SampleRelationshipPE sampleRelationship : parentRelationships) {
            SamplePE parent = sampleRelationship.getChildSample();
            if (parent != null) {
                parent.getSampleParentRelationships().remove(sampleRelationship);
            }
            this.addParentRelationship(sampleRelationship);
        }
    }

    public void addParentRelationship(SampleRelationshipPE relationship) {
        relationship.setChildSample(this);
        this.getSampleParentRelationships().add(relationship);
    }

    public void removeParentRelationship(SampleRelationshipPE relationship) {
        this.getSampleParentRelationships().remove(relationship);
        relationship.getParentSample().getSampleChildRelationships().remove(relationship);
        relationship.setChildSample(null);
        relationship.setParentSample(null);
    }

    public void removeDataSet(DataPE dataset) {
        this.getDatasetsInternal().remove(dataset);
        dataset.setSampleInternal(null);
    }

    public void addDataSet(DataPE dataset) {
        SamplePE sample = dataset.tryGetSample();
        if (sample != null) {
            sample.getDatasetsInternal().remove(dataset);
        }
        dataset.setSampleInternal(this);
        this.getDatasetsInternal().add(dataset);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="sampleInternal")
    private Set<DataPE> getDatasetsInternal() {
        return this.datasets;
    }

    private void setDatasetsInternal(Set<DataPE> datasets) {
        this.datasets = datasets;
    }

    @Transient
    public Set<DataPE> getDatasets() {
        return new UnmodifiableSetDecorator<DataPE>(this.getDatasetsInternal());
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @Transient
    public SampleIdentifier getSampleIdentifier() {
        if (this.sampleIdentifier == null) {
            this.sampleIdentifier = IdentifierHelper.createSampleIdentifier(this);
        }
        return this.sampleIdentifier;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dbin_id", updatable=true)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="space_id", updatable=true)
    @IndexedEmbedded(prefix="space ")
    public SpacePE getSpace() {
        return this.space;
    }

    public void setSpace(SpacePE space) {
        this.space = space;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Sample type can not be null.")
    @JoinColumn(name="saty_id", updatable=false)
    @IndexedEmbedded(prefix="type ")
    public SampleTypePE getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleTypePE sampleType) {
        this.sampleType = sampleType;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @IndexedEmbedded(prefix="property ")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<SamplePropertyPE> getSampleProperties() {
        return this.properties;
    }

    private void setSampleProperties(Set<SamplePropertyPE> properties) {
        this.properties = properties;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="samp_id_part_of", updatable=true)
    public SamplePE getContainer() {
        return this.container;
    }

    @Transient
    @Field(index=Index.UN_TOKENIZED, store=Store.YES, name="container id")
    private Long getContainerId() {
        Long result = null;
        if (this.getContainer() != null) {
            result = HibernateUtils.getId(this.getContainer());
            assert (result != null);
        }
        return result;
    }

    public void setContainer(SamplePE container) {
        this.container = container;
        this.sampleIdentifier = null;
    }

    @Transient
    public SamplePE getTop() {
        List<SamplePE> parents = this.getParents();
        if (parents.size() == 1) {
            return parents.get(0).getTop();
        }
        return this;
    }

    @Transient
    public SamplePE getGeneratedFrom() {
        List<SamplePE> parents = this.getParents();
        if (parents.size() == 0) {
            return null;
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("Sample " + this.getIdentifier() + " has more than one parent");
        }
        return parents.get(0);
    }

    @Transient
    public List<SamplePE> getParents() {
        Set<SampleRelationshipPE> relationships = this.getParentRelationships();
        ArrayList<SamplePE> parents = new ArrayList<SamplePE>();
        for (SampleRelationshipPE r : relationships) {
            assert (r.getChildSample().equals(this));
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            parents.add(r.getParentSample());
        }
        return parents;
    }

    public void setExperiment(ExperimentPE experiment) {
        if (experiment != null) {
            experiment.addSample(this);
        } else {
            ExperimentPE previousExperiment = this.getExperiment();
            if (previousExperiment != null) {
                previousExperiment.removeSample(this);
            }
        }
    }

    @Transient
    public ExperimentPE getExperiment() {
        return this.getExperimentInternal();
    }

    void setExperimentInternal(ExperimentPE experiment) {
        this.experiment = experiment;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="expe_id", updatable=true)
    private ExperimentPE getExperimentInternal() {
        return this.experiment;
    }

    @Transient
    @Field(index=Index.UN_TOKENIZED, store=Store.YES, name="experiment id")
    private Long getExperimentId() {
        Long result = null;
        if (this.getExperimentInternal() != null) {
            result = HibernateUtils.getId(this.getExperimentInternal());
            assert (result != null);
        }
        return result;
    }

    @Override
    @SequenceGenerator(name="SAMPLE_ID_SEQ", sequenceName="SAMPLE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_ID_SEQ")
    @DocumentId(name="id")
    public final Long getId() {
        return this.id;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    @Transient
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    private String getFullCode() {
        return String.valueOf(this.getContainer() != null ? String.valueOf(this.getContainer().getCode()) + ":" : "") + this.getCode();
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    @Field(name="registration_date", index=Index.UN_TOKENIZED, store=Store.NO)
    @DateBridge(resolution=Resolution.DAY)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    @IndexedEmbedded(prefix="registrator ")
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SamplePE)) {
            return false;
        }
        SamplePE that = (SamplePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        builder.append((Object)this.getSpace(), (Object)that.getSpace());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDatabaseInstance());
        builder.append((Object)this.getSpace());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("sampleType", (Object)this.getSampleType());
        return builder.toString();
    }

    @Override
    public final int compareTo(SamplePE o) {
        return this.getSampleIdentifier().compareTo(o.getSampleIdentifier());
    }

    @Transient
    public Set<SamplePropertyPE> getProperties() {
        return new UnmodifiableSetDecorator<SamplePropertyPE>(this.getSampleProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getSampleProperties());
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getSampleProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            SamplePropertyPE sampleProperty = (SamplePropertyPE)entityPropertyPE;
            SamplePE parent = sampleProperty.getEntity();
            if (parent != null) {
                parent.getSampleProperties().remove(sampleProperty);
            }
            this.addProperty(sampleProperty);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        this.getSampleProperties().add((SamplePropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getSampleProperties().remove(property);
        property.setEntity(null);
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    @Field(name="modification_date", index=Index.UN_TOKENIZED, store=Store.NO)
    @DateBridge(resolution=Resolution.DAY)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Override
    @Transient
    @Field(index=Index.NO, store=Store.YES, name="identifier")
    public final String getIdentifier() {
        return this.getSampleIdentifier().toString();
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getSampleType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    @Override
    @Transient
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.SAMPLE;
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="sampleParentInternal", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @IndexedEmbedded(prefix="attachment ")
    @Fetch(value=FetchMode.SUBSELECT)
    protected Set<AttachmentPE> getInternalAttachments() {
        return this.attachments;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    @Field(index=Index.NO, store=Store.YES, name="perm_id")
    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="container")
    public List<SamplePE> getContained() {
        return this.contained;
    }

    private void setContained(List<SamplePE> contained) {
        this.contained = contained;
    }

    @Transient
    public List<SamplePE> getGenerated() {
        Set<SampleRelationshipPE> relationships = this.getChildRelationships();
        ArrayList<SamplePE> samples = new ArrayList<SamplePE>();
        for (SampleRelationshipPE r : relationships) {
            assert (r.getParentSample().equals(this));
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            samples.add(r.getChildSample());
        }
        return samples;
    }

    @Transient
    public Map<RelationshipTypePE, Set<SamplePE>> getParentsMap() {
        HashMap<RelationshipTypePE, Set<SamplePE>> map = new HashMap<RelationshipTypePE, Set<SamplePE>>();
        for (SampleRelationshipPE r : this.getParentRelationships()) {
            RelationshipTypePE type = r.getRelationship();
            if (map.get(type) == null) {
                map.put(type, new HashSet());
            }
            ((Set)map.get(type)).add(r.getParentSample());
        }
        return map;
    }
}

