/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.utilities.StringUtilities;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceIdentifier
extends DatabaseInstanceIdentifier
implements Comparable<SpaceIdentifier> {
    private static final long serialVersionUID = 32L;
    private String spaceCodeOrNull;

    public static SpaceIdentifier createHome() {
        return new SpaceIdentifier(SpaceIdentifier.getHomeSpaceCode(), DatabaseInstanceIdentifier.HOME);
    }

    public SpaceIdentifier(String spaceCode) {
        this(DatabaseInstanceIdentifier.HOME, spaceCode);
    }

    public SpaceIdentifier(DatabaseInstanceIdentifier databaseInstanceIdentifier, String spaceCode) {
        this(databaseInstanceIdentifier.getDatabaseInstanceCode(), spaceCode);
    }

    public SpaceIdentifier(String databaseInstanceCode, String spaceCode) {
        super(databaseInstanceCode);
        this.setSpaceCode(spaceCode);
    }

    public final String getSpaceCode() {
        return StringUtils.upperCase((String)this.spaceCodeOrNull);
    }

    public final void setSpaceCode(String spaceCode) {
        this.spaceCodeOrNull = spaceCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpaceIdentifier)) {
            return false;
        }
        SpaceIdentifier that = (SpaceIdentifier)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getDatabaseInstanceCode(), (Object)that.getDatabaseInstanceCode());
        builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
        return builder.isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getDatabaseInstanceCode());
        builder.append((Object)this.getSpaceCode());
        return builder.toHashCode();
    }

    @Override
    public String toString() {
        if (this.getDatabaseInstanceCode() == null) {
            return String.valueOf('/') + this.spaceCodeOrNull;
        }
        return String.valueOf(super.toString()) + ':' + '/' + this.spaceCodeOrNull;
    }

    protected static String getHomeSpaceCode() {
        return SpaceCodeHelper.HOME_SPACE_CODE;
    }

    public boolean isHomeSpace() {
        return SpaceCodeHelper.isHomeSpace(this.spaceCodeOrNull);
    }

    private SpaceIdentifier() {
    }

    @Override
    public final int compareTo(SpaceIdentifier other) {
        int dbCompare = super.compareTo(other);
        if (dbCompare == 0) {
            return StringUtilities.compareNullable(this.getSpaceCode(), other.getSpaceCode());
        }
        return dbCompare;
    }

    public static /* bridge */ /* synthetic */ DatabaseInstanceIdentifier createHome() {
        return SpaceIdentifier.createHome();
    }
}

