/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptTranslator {
    private ScriptTranslator() {
    }

    public static final List<Script> translate(List<ScriptPE> scripts) {
        ArrayList<Script> result = new ArrayList<Script>();
        for (ScriptPE script : scripts) {
            result.add(ScriptTranslator.translate(script));
        }
        return result;
    }

    public static Script translate(ScriptPE script) {
        if (script == null) {
            return null;
        }
        Script result = new Script();
        result.setId(HibernateUtils.getId(script));
        result.setScriptType(script.getScriptType());
        result.setEntityKind(script.getEntityKind());
        result.setName(script.getName());
        result.setDescription(script.getDescription());
        result.setScript(script.getScript());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(script.getDatabaseInstance()));
        result.setRegistrationDate(script.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(script.getRegistrator()));
        return result;
    }
}

