/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.shared.basic.utils.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataTypeUtils {
    private static final Map<DataTypeCode, Converter> map = new HashMap<DataTypeCode, Converter>();

    public static ISerializableComparable convertTo(DataTypeCode dataTypeCode, String value) {
        return Converter.resolve(dataTypeCode).convert(value);
    }

    public static Serializable convertValueTo(DataTypeCode dataTypeCode, String value) {
        return Converter.resolve(dataTypeCode).convertValue(value);
    }

    public static DataTypeCode getCompatibleDataType(DataTypeCode previousDataTypeOrNull, DataTypeCode dataType) {
        if (previousDataTypeOrNull == null) {
            return dataType;
        }
        if (dataType == null) {
            return previousDataTypeOrNull;
        }
        if (previousDataTypeOrNull == DataTypeCode.REAL) {
            if (dataType == DataTypeCode.REAL || dataType == DataTypeCode.INTEGER) {
                return DataTypeCode.REAL;
            }
            return DataTypeCode.VARCHAR;
        }
        if (previousDataTypeOrNull == DataTypeCode.INTEGER) {
            if (dataType == DataTypeCode.REAL) {
                return DataTypeCode.REAL;
            }
            if (dataType == DataTypeCode.INTEGER) {
                return DataTypeCode.INTEGER;
            }
            return DataTypeCode.VARCHAR;
        }
        if (previousDataTypeOrNull == DataTypeCode.TIMESTAMP && dataType == DataTypeCode.TIMESTAMP) {
            return DataTypeCode.TIMESTAMP;
        }
        return DataTypeCode.VARCHAR;
    }

    private DataTypeUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Converter implements Serializable
    {
        INTEGER(new DataTypeCode[]{DataTypeCode.INTEGER}){

            public ISerializableComparable doConversion(String value) {
                return new IntegerTableCell(this.doSimpleConversion(value));
            }

            public Long doSimpleConversion(String value) {
                try {
                    return new Long(value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Is not an integer number: " + value);
                }
            }
        }
        ,
        DOUBLE(new DataTypeCode[]{DataTypeCode.REAL}){

            public ISerializableComparable doConversion(String value) {
                return new DoubleTableCell(this.doSimpleConversion(value));
            }

            public Double doSimpleConversion(String value) {
                try {
                    return new Double(value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Is not a floating point number: " + value);
                }
            }
        }
        ,
        STRING(new DataTypeCode[]{DataTypeCode.VARCHAR, DataTypeCode.MULTILINE_VARCHAR, DataTypeCode.BOOLEAN, DataTypeCode.XML, DataTypeCode.CONTROLLEDVOCABULARY, DataTypeCode.MATERIAL, DataTypeCode.HYPERLINK, DataTypeCode.TIMESTAMP}){

            public ISerializableComparable doConversion(String value) {
                return new StringTableCell(value);
            }

            public Serializable doSimpleConversion(String value) {
                return value;
            }
        };

        private static final StringTableCell EMPTY_CELL;

        static {
            EMPTY_CELL = new StringTableCell("");
        }

        private Converter(DataTypeCode ... codes) {
            DataTypeCode[] dataTypeCodeArray = codes;
            int n2 = codes.length;
            int n3 = 0;
            while (n3 < n2) {
                DataTypeCode dataTypeCode = dataTypeCodeArray[n3];
                map.put(dataTypeCode, this);
                ++n3;
            }
        }

        public static Converter resolve(DataTypeCode dataTypeCode) {
            return (Converter)map.get(dataTypeCode);
        }

        public ISerializableComparable convert(String value) {
            if (StringUtils.isBlank(value)) {
                return EMPTY_CELL;
            }
            if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
                return new StringTableCell(value.substring(1));
            }
            return this.doConversion(value);
        }

        public Serializable convertValue(String value) {
            return StringUtils.isBlank(value) ? null : this.doSimpleConversion(value);
        }

        protected abstract ISerializableComparable doConversion(String var1);

        protected abstract Serializable doSimpleConversion(String var1);
    }
}

