/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.common.collections.ToStringDefaultConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static final <T> String abbreviate(T[] objects, int maxLength) {
        return CollectionUtils.abbreviate(objects, maxLength, true);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength) {
        return CollectionUtils.abbreviate(collection, maxLength, true);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, CollectionStyle style) {
        return CollectionUtils.abbreviate(objects, maxLength, true, ToStringDefaultConverter.getInstance(), style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, CollectionStyle style) {
        return CollectionUtils.abbreviate(collection, maxLength, ToStringDefaultConverter.getInstance(), style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(collection, maxLength, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, IToStringConverter<? super T> converter, CollectionStyle style) {
        return CollectionUtils.abbreviate(collection, maxLength, true, converter, style);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft) {
        return CollectionUtils.abbreviate(objects, maxLength, showLeft, ToStringDefaultConverter.getInstance());
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft) {
        return CollectionUtils.abbreviate(collection, maxLength, showLeft, ToStringDefaultConverter.getInstance());
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(objects, maxLength, showLeft, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(T[] objects, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(objects, -1, false, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(collection, maxLength, showLeft, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (objects != null) : "Given objects can not be null.";
        return CollectionUtils.abbreviate(Arrays.asList(objects), maxLength, showLeft, converter, style);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (objects != null) : "Given objects can not be null.";
        return CollectionUtils.abbreviate(Arrays.asList(objects), maxLength, true, converter, style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (collection != null) : "Given collection can not be null.";
        assert (converter != null) : "Given converter can not be null.";
        assert (style != null) : "Given style can not be null.";
        StringBuilder builder = new StringBuilder(style.getCollectionStart());
        Iterator<T> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext() && (i < maxLength || maxLength < 0)) {
            if (i > 0) {
                builder.append(style.getCollectionSeparator());
            }
            builder.append(converter.toString(iterator.next()));
            ++i;
        }
        int size = collection.size();
        if (maxLength > 0 && maxLength < size) {
            builder.append(style.getCollectionSeparator());
            builder.append("...");
            if (showLeft) {
                builder.append(" (").append(size - maxLength).append(" left)");
            }
        }
        builder.append(style.getCollectionEnd());
        return builder.toString();
    }

    public static final <T> List<T> asList(Iterator<T> iterator) {
        assert (iterator != null) : "Given iterator can not be null.";
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static final <K, V> List<K> map(Collection<V> list, ICollectionMappingFunction<K, V> mapping) {
        ArrayList<K> mapped = new ArrayList<K>();
        for (V elem : list) {
            mapped.add(mapping.map(elem));
        }
        return mapped;
    }

    public static <V> List<V> filter(Collection<V> list, ICollectionFilter<V> filter) {
        ArrayList<V> filtered = new ArrayList<V>();
        for (V elem : list) {
            if (!filter.isPresent(elem)) continue;
            filtered.add(elem);
        }
        return filtered;
    }

    public static <E> Collection<E> nullSafe(Collection<E> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static <E, C extends Comparable<C>> void sort(List<E> list, final IKeyExtractor<C, E> sortCriteriaKeyExtractor) {
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                Comparable key1 = (Comparable)sortCriteriaKeyExtractor.getKey(o1);
                Comparable key2 = (Comparable)sortCriteriaKeyExtractor.getKey(o2);
                return key1.compareTo(key2);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICollectionFilter<V> {
        public boolean isPresent(V var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICollectionMappingFunction<K, V> {
        public K map(V var1);
    }
}

