/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.IExtendedBlockingQueue;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E>
implements IExtendedBlockingQueue<E> {
    private static final long serialVersionUID = -6903933977591709194L;
    private static final long PEEK_INTERVAL_MILLIS = 100L;

    public ExtendedLinkedBlockingQueue() {
    }

    public ExtendedLinkedBlockingQueue(Collection<? extends E> c) {
        super(c);
    }

    public ExtendedLinkedBlockingQueue(int capacity) {
        super(capacity);
    }

    @Override
    public E peekWait() throws InterruptedException {
        Object item;
        while ((item = this.peek()) == null) {
            Thread.sleep(100L);
        }
        return item;
    }

    @Override
    public E peekWait(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long maxCount = Math.max(1L, timeoutMillis / 100L);
        int i = 0;
        while ((long)i < maxCount) {
            Object item = this.peek();
            if (item != null) {
                return item;
            }
            Thread.sleep(100L);
            ++i;
        }
        return null;
    }
}

