/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.file;

import ch.systemsx.cisd.common.compression.file.CompressionWorker;
import ch.systemsx.cisd.common.compression.file.FailureRecord;
import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Compressor {
    private static final Logger machineLog;
    private static final Logger operationLog;
    private static final int NUMBER_OF_PROCESSORS;

    static {
        LogInitializer.init();
        machineLog = LogFactory.getLogger(LogCategory.MACHINE, Compressor.class);
        operationLog = LogFactory.getLogger(LogCategory.OPERATION, Compressor.class);
        NUMBER_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
    }

    private static Queue<File> tryFillWorkerQueue(File directory, FileFilter filter) throws EnvironmentFailureException {
        File[] filesToCompressOrNull = FileUtilities.tryListFiles(directory, filter, new Log4jSimpleLogger(machineLog));
        if (filesToCompressOrNull == null) {
            String errorMsg = String.format("Path '%s' is not a directory.", directory.getPath());
            machineLog.error((Object)errorMsg);
            throw new EnvironmentFailureException(errorMsg);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Found %d files to compress.", filesToCompressOrNull.length));
        }
        if (filesToCompressOrNull.length == 0) {
            return null;
        }
        return new ArrayBlockingQueue<File>(filesToCompressOrNull.length, false, Arrays.asList(filesToCompressOrNull));
    }

    private static int getInitialNumberOfWorkers(int threadsPerProcessor) {
        assert (threadsPerProcessor > 0);
        return NUMBER_OF_PROCESSORS * threadsPerProcessor;
    }

    private static void startUpWorkerThreads(AtomicInteger workersCounter, Queue<File> workerQueue, Collection<FailureRecord> failed, ICompressionMethod compressor) {
        int counter = workersCounter.get();
        int i = 0;
        while (i < counter) {
            new Thread((Runnable)new CompressionWorker(workerQueue, failed, compressor, workersCounter), "Compressor " + i).start();
            ++i;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Started up %d worker threads.", counter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FailureRecord> start(String directoryName, ICompressionMethod compressionMethod, int threadsPerProcessor) throws InterruptedException, EnvironmentFailureException {
        if (compressionMethod instanceof ISelfTestable) {
            ((ISelfTestable)((Object)compressionMethod)).check();
        }
        Queue<File> workerQueue = Compressor.tryFillWorkerQueue(new File(directoryName), compressionMethod);
        Collection<FailureRecord> failed = Collections.synchronizedCollection(new ArrayList());
        if (workerQueue == null || workerQueue.size() == 0) {
            System.out.println("No files to compress.");
            return failed;
        }
        AtomicInteger workersCounter = new AtomicInteger(Compressor.getInitialNumberOfWorkers(threadsPerProcessor));
        Compressor.startUpWorkerThreads(workersCounter, workerQueue, failed, compressionMethod);
        Collection<FailureRecord> collection = failed;
        synchronized (collection) {
            while (workersCounter.get() > 0) {
                failed.wait();
            }
        }
        return failed;
    }
}

