/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.tiff;

import ch.systemsx.cisd.common.compression.file.Compressor;
import ch.systemsx.cisd.common.compression.file.FailureRecord;
import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.compression.tiff.TiffConvertCompressionMethod;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.util.Collection;

@Deprecated
public class TiffCompressor
extends Compressor {
    public static void main(String[] args) {
        String errorMsgOrNull;
        if (args.length != 1) {
            System.err.println("Syntax: TiffCompressor <directory>");
            System.exit(1);
        }
        if ((errorMsgOrNull = TiffCompressor.tryCompress(args[0])) != null) {
            System.err.print(errorMsgOrNull);
        }
    }

    private static String tryCompress(String path) {
        try {
            return TiffCompressor.compress(path, 1, TiffConvertCompressionMethod.create(null));
        }
        catch (InterruptedException ex) {
            return "Compression was interrupted:" + ex.getMessage();
        }
        catch (EnvironmentFailureException ex) {
            return ex.getMessage();
        }
    }

    public static String compress(String path, int threadsPerProcessor, ICompressionMethod compressionMethod) throws InterruptedException, EnvironmentFailureException {
        assert (path != null);
        assert (compressionMethod != null);
        assert (threadsPerProcessor > 0);
        StringBuilder errorMsgBuilder = new StringBuilder();
        Collection<FailureRecord> failed = TiffCompressor.start(path, compressionMethod, threadsPerProcessor);
        if (failed.size() > 0) {
            errorMsgBuilder.append("The following files could not bee successfully compressed:\n");
            for (FailureRecord r : failed) {
                errorMsgBuilder.append(String.format("%s (%s)\n", r.getFailedFile().getName(), r.getFailureStatus()));
            }
            return errorMsgBuilder.toString();
        }
        return null;
    }
}

