/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.tiff;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.compression.tiff.AbstractTiffCompressionMethod;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TiffConvertCompressionMethod
extends AbstractTiffCompressionMethod {
    private static final String executableName = "convert";
    private static final File executable = OSUtilities.findExecutable((String)"convert");
    private static final String DEFAULT_COMPRESSION_TYPE = "LZW";

    private static String getImageMagickVersion(String convertExecutableToCheck) {
        ProcessResult result = ProcessExecutionHelper.run(Arrays.asList(convertExecutableToCheck, "--version"), operationLog, machineLog, 60000L, ProcessIOStrategy.DEFAULT_IO_STRATEGY, true);
        result.log();
        String versionString = TiffConvertCompressionMethod.extractImageMagickVersion(result.getOutput().get(0));
        return versionString;
    }

    private static String extractImageMagickVersion(String imageMagickVersionLine) {
        if (!imageMagickVersionLine.startsWith("Version: ImageMagick")) {
            return null;
        }
        String[] versionStringParts = imageMagickVersionLine.split("\\s+");
        if (versionStringParts.length < 3) {
            return null;
        }
        return versionStringParts[2];
    }

    public static TiffConvertCompressionMethod create(String compressionTypeOrNull) {
        return compressionTypeOrNull == null ? new TiffConvertCompressionMethod() : new TiffConvertCompressionMethod(compressionTypeOrNull);
    }

    private TiffConvertCompressionMethod() {
        this(DEFAULT_COMPRESSION_TYPE);
    }

    private TiffConvertCompressionMethod(String compressionType) {
        super(compressionType);
    }

    @Override
    protected List<String> createCommandLine(File fileToCompress, File inProgressFile) {
        assert (executable != null);
        assert (fileToCompress != null);
        assert (fileToCompress.isFile());
        assert (inProgressFile != null);
        assert (!inProgressFile.exists());
        List<String> parameters = Arrays.asList(executable.getAbsolutePath(), fileToCompress.getAbsolutePath(), "-compress", this.getCompressionType(), inProgressFile.getAbsolutePath());
        return parameters;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        super.check();
        String imageMagickVersionOrNull = TiffConvertCompressionMethod.getImageMagickVersion(executable.getAbsolutePath());
        if (imageMagickVersionOrNull == null) {
            throw new ConfigurationFailureException("Invalid convert utility");
        }
        String[] imageMagickVersionParts = imageMagickVersionOrNull.split("\\.");
        if (imageMagickVersionParts.length != 3) {
            throw new ConfigurationFailureException("Invalid convert utility");
        }
        int imageMagickMajorVersion = Integer.parseInt(imageMagickVersionParts[0]);
        int imageMagickMinorVersion = Integer.parseInt(imageMagickVersionParts[1]);
        if (imageMagickMajorVersion < 6 || imageMagickMinorVersion < 2) {
            throw ConfigurationFailureException.fromTemplate("Convert utility is too old (expected: v6.2 or newer, found: v%s)", imageMagickVersionOrNull);
        }
        if (machineLog.isInfoEnabled()) {
            machineLog.info((Object)String.format("Using convert executable '%s', ImageMagick version %s", executable, imageMagickVersionOrNull));
        }
    }

    public static void main(String[] args) {
        LogInitializer.init();
        TiffConvertCompressionMethod compressor = new TiffConvertCompressionMethod();
        compressor.check();
    }

    @Override
    protected File getExecutable() {
        return executable;
    }

    @Override
    protected String getExecutableName() {
        return executableName;
    }
}

