/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TerminableFuture<V>
implements ITerminableFuture<V> {
    private final Future<V> delegateFuture;
    private final TerminableCallable<V> delegateTerminableCallable;

    public TerminableFuture(Future<V> delegateFuture, TerminableCallable<V> delegateTerminableCallable) {
        this.delegateFuture = delegateFuture;
        this.delegateTerminableCallable = delegateTerminableCallable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = this.delegateTerminableCallable.cancel(mayInterruptIfRunning);
        this.delegateFuture.cancel(false);
        return canceled;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegateFuture.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegateFuture.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.delegateTerminableCallable.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegateFuture.isDone();
    }

    @Override
    public boolean isRunning() {
        return this.delegateTerminableCallable.isRunning();
    }

    @Override
    public boolean hasStarted() {
        return this.delegateTerminableCallable.hasStarted();
    }

    @Override
    public boolean waitForFinished(long timeoutMillis) throws InterruptedExceptionUnchecked {
        return this.delegateTerminableCallable.waitForFinished(timeoutMillis);
    }

    @Override
    public boolean hasFinished() {
        return this.delegateTerminableCallable.hasFinished();
    }

    @Override
    public boolean terminate() {
        this.cancel(false);
        return this.delegateTerminableCallable.terminate();
    }

    @Override
    public final boolean terminate(long timeoutMillis) throws InterruptedExceptionUnchecked {
        this.cancel(false);
        return this.delegateTerminableCallable.terminate(timeoutMillis);
    }
}

