/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import ch.systemsx.cisd.common.utilities.ExceptionUtils;
import java.sql.SQLException;

public final class SQLStateUtils {
    public static final String NULL_VALUE_VIOLATION = "23502";
    public static final String FOREIGN_KEY_VIOLATION = "23503";
    public static final String UNIQUE_VIOLATION = "23505";
    public static final String INVALID_CATALOG_NAME = "3D000";
    public static final String DUPLICATE_OBJECT = "42710";
    public static final String DUPLICATE_DATABASE = "42P04";

    private SQLStateUtils() {
    }

    public static final String tryGetSqlState(Throwable ex) {
        assert (ex != null) : "Throwable unspecified";
        SQLException nextExceptionOrNull = SQLStateUtils.tryGetNextExceptionWithNonNullState(ex);
        if (nextExceptionOrNull != null) {
            return nextExceptionOrNull.getSQLState();
        }
        return null;
    }

    public static final SQLException tryGetNextExceptionWithNonNullState(Throwable ex) {
        assert (ex != null) : "Throwable unspecified";
        SQLException sqlExceptionOrNull = ExceptionUtils.tryGetThrowableOfClass(ex, SQLException.class);
        if (sqlExceptionOrNull != null) {
            SQLException nextException = sqlExceptionOrNull;
            String sqlStateOrNull = nextException.getSQLState();
            while (sqlStateOrNull == null && nextException.getNextException() != null) {
                nextException = nextException.getNextException();
                sqlStateOrNull = nextException.getSQLState();
            }
            return nextException;
        }
        return null;
    }

    public static final boolean isDuplicateObject(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return DUPLICATE_OBJECT.equalsIgnoreCase(sqlState);
    }

    public static final boolean isDuplicateDatabase(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return DUPLICATE_DATABASE.equalsIgnoreCase(sqlState);
    }

    public static final boolean isInvalidCatalogName(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return INVALID_CATALOG_NAME.equalsIgnoreCase(sqlState);
    }

    public static final boolean isUniqueViolation(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return UNIQUE_VIOLATION.equalsIgnoreCase(sqlState);
    }

    public static final boolean isForeignKeyViolation(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return FOREIGN_KEY_VIOLATION.equalsIgnoreCase(sqlState);
    }

    public static final boolean isNullValueConstraintViolation(String sqlState) {
        assert (sqlState != null) : "SQL state unspecified";
        return NULL_VALUE_VIOLATION.equalsIgnoreCase(sqlState);
    }
}

