/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUnitTestRunner {
    public static final String MIGRATION_FOLDER = "migration";
    private final ISqlScriptExecutor executor;
    private final PrintWriter writer;

    public SqlUnitTestRunner(ISqlScriptExecutor executor, PrintWriter writer) {
        assert (executor != null) : "Undefined SQL script executor.";
        assert (writer != null) : "Undefined writer.";
        this.executor = executor;
        this.writer = writer;
    }

    public void run(File testScriptsFolder) throws AssertionError {
        if (testScriptsFolder == null || !testScriptsFolder.exists()) {
            return;
        }
        Object[] testCases = testScriptsFolder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isDirectory() && !name.startsWith(".") && !name.startsWith(SqlUnitTestRunner.MIGRATION_FOLDER);
            }
        });
        Arrays.sort(testCases);
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        Object[] objectArray = testCases;
        int n = testCases.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            this.runTestCase((File)file, results);
            ++n2;
        }
        StringBuilder builder = new StringBuilder();
        for (TestResult result : results) {
            if (result.isOK()) continue;
            File testScript = result.getTestScript();
            Throwable throwable = result.getThrowable();
            builder.append("Script '").append(testScript.getName()).append("' of test case '");
            builder.append(testScript.getParentFile().getName()).append("' failed because of ");
            builder.append(throwable).append(OSUtilities.LINE_SEPARATOR);
            StringWriter stacktraceWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stacktraceWriter);
            throwable.printStackTrace(pw);
            builder.append(stacktraceWriter.toString()).append(OSUtilities.LINE_SEPARATOR);
        }
        if (builder.length() > 0) {
            throw new AssertionError((Object)builder.toString());
        }
    }

    private void runTestCase(File testCaseFolder, List<TestResult> results) {
        File[] testScripts;
        this.writer.println("====== Test case: " + testCaseFolder.getName() + " ======");
        File buildupFile = new File(testCaseFolder, "buildup.sql");
        if (buildupFile.exists()) {
            TestResult result = this.runScript(buildupFile);
            results.add(result);
            if (!result.isOK()) {
                this.writer.println("       script failed: skip test scripts and teardown script.");
                return;
            }
        }
        File[] fileArray = testScripts = this.getTestScripts(testCaseFolder);
        int n = testScripts.length;
        int n2 = 0;
        while (n2 < n) {
            File testScript = fileArray[n2];
            results.add(this.runScript(testScript));
            ++n2;
        }
        File teardownFile = new File(testCaseFolder, "teardown.sql");
        if (teardownFile.exists()) {
            results.add(this.runScript(teardownFile));
        }
    }

    private File[] getTestScripts(File testCaseFolder) {
        File[] testScripts = testCaseFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return SqlUnitTestRunner.this.getNumber(name) >= 0;
            }
        });
        Arrays.sort(testScripts, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return SqlUnitTestRunner.this.getNumber(f1.getName()) - SqlUnitTestRunner.this.getNumber(f2.getName());
            }
        });
        return testScripts;
    }

    /*
     * Unable to fully structure code
     */
    private TestResult runScript(File scriptFile) {
        this.writer.println("     execute script " + scriptFile.getName());
        try {
            this.executor.execute(new Script(scriptFile.getName(), FileUtilities.loadToString(scriptFile)), true, null);
            return new TestResult(scriptFile);
        }
        catch (Throwable t) {
            ** while (t.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            t = t.getCause();
            continue;
        }
lbl9:
        // 1 sources

        return new TestResult(scriptFile, t);
    }

    private int getNumber(String name) {
        int index = name.indexOf(61);
        if (index < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(name.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static final class TestResult {
        private final boolean ok;
        private final Throwable throwable;
        private final File testScript;

        public TestResult(File testScript) {
            this(testScript, true, null);
        }

        public TestResult(File testScript, Throwable throwable) {
            this(testScript, false, throwable);
        }

        public TestResult(File testScript, boolean ok, Throwable throwable) {
            this.testScript = testScript;
            this.ok = ok;
            this.throwable = throwable;
        }

        public final File getTestScript() {
            return this.testScript;
        }

        public final boolean isOK() {
            return this.ok;
        }

        public final Throwable getThrowable() {
            return this.throwable;
        }
    }
}

