/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.exceptions;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusWithResult<T>
extends Status {
    private final T resultOrNull;

    public static <T> StatusWithResult<T> create(T resultOrNull) {
        return new StatusWithResult<T>(StatusFlag.OK, null, resultOrNull);
    }

    public static <T> StatusWithResult<T> createError(boolean retriable) {
        return new StatusWithResult<Object>(StatusWithResult.getErrorFlag(retriable), "", null);
    }

    public static <T> StatusWithResult<T> createError(boolean retriable, String message) {
        assert (message != null);
        return new StatusWithResult<Object>(StatusWithResult.getErrorFlag(retriable), message, null);
    }

    public static <T> StatusWithResult<T> createError() {
        return new StatusWithResult<Object>(StatusFlag.ERROR, "", null);
    }

    public static <T> StatusWithResult<T> createError(String message) {
        assert (message != null);
        return new StatusWithResult<Object>(StatusFlag.ERROR, message, null);
    }

    public static <T> StatusWithResult<T> createRetriableError() {
        return new StatusWithResult<Object>(StatusFlag.RETRIABLE_ERROR, "", null);
    }

    public static <T> StatusWithResult<T> createRetriableError(String message) {
        assert (message != null);
        return new StatusWithResult<Object>(StatusFlag.RETRIABLE_ERROR, message, null);
    }

    protected StatusWithResult(StatusFlag flag, String messageOrNull, T resultOrNull) {
        super(flag, messageOrNull);
        this.resultOrNull = resultOrNull;
    }

    public final T tryGetResult() {
        return this.resultOrNull;
    }

    private StatusWithResult<T> toStatusWithResult(Object obj) {
        return (StatusWithResult)obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StatusWithResult)) {
            return false;
        }
        StatusWithResult<T> that = this.toStatusWithResult(obj);
        return this.getFlag() == that.getFlag() && ObjectUtils.equals((Object)this.tryGetErrorMessage(), (Object)that.tryGetErrorMessage()) && ObjectUtils.equals(this.tryGetResult(), that.tryGetResult());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getFlag());
        builder.append((Object)this.tryGetErrorMessage());
        builder.append(this.tryGetResult());
        return builder.toHashCode();
    }

    @Override
    public String toString() {
        String messageOrNull = this.tryGetErrorMessage();
        if (StringUtils.isNotBlank((String)messageOrNull)) {
            return String.valueOf(this.getFlag().toString()) + ": \"" + messageOrNull + "\"";
        }
        if (this.resultOrNull != null) {
            return String.valueOf(this.getFlag().toString()) + ": result is \"" + this.resultOrNull + "\"";
        }
        return this.getFlag().toString();
    }
}

