/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fileconverter.IFileConversionMethod;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractExecutableFileConverter
implements IFileConversionMethod {
    protected final Logger machineLog;
    protected final Logger operationLog;
    private final File executable = OSUtilities.findExecutable((String)this.getExecutableName());

    protected AbstractExecutableFileConverter(Logger machineLog, Logger operationLog) {
        this.machineLog = machineLog;
        this.operationLog = operationLog;
    }

    protected abstract String getExecutableName();

    protected String getExecutablePath() {
        return this.executable == null ? "? (" + this.getExecutableName() + ")" : this.executable.getAbsolutePath();
    }

    protected abstract List<String> getCommandLine(File var1, File var2);

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        if (this.executable == null) {
            throw new ConfigurationFailureException("Cannot find executable of the " + this.getExecutableName() + " utility.");
        }
    }

    @Override
    public boolean convert(File inFile, File outFile) {
        boolean exists;
        ProcessResult processResult = this.runExecutable(this.getCommandLine(inFile, outFile));
        boolean processOK = ProcessExecutionHelper.log(processResult);
        boolean bl = exists = outFile.exists() && outFile.length() > 0L;
        if (!exists) {
            this.operationLog.error((Object)("Outfile '" + outFile.getAbsolutePath() + "' does not exist after processing."));
        }
        return processOK && exists;
    }

    protected ProcessResult runExecutable(List<String> commandLine) {
        ArrayList<String> fullCommandLine = new ArrayList<String>();
        fullCommandLine.add(this.executable.getAbsolutePath());
        fullCommandLine.addAll(commandLine);
        ProcessResult processResult = ProcessExecutionHelper.run(fullCommandLine, this.operationLog, this.machineLog, false);
        return processResult;
    }
}

