/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IOutputStream;
import ch.systemsx.cisd.common.exceptions.UnknownLastChangedException;
import ch.systemsx.cisd.common.filesystem.IFileRemover;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IFileOperations
extends IFileRemover {
    public String getCanonicalPath(File var1) throws IOExceptionUnchecked;

    public File getCanonicalFile(File var1) throws IOExceptionUnchecked;

    public boolean canRead(File var1);

    public boolean canWrite(File var1);

    public boolean exists(File var1);

    public boolean isDirectory(File var1);

    public boolean isFile(File var1);

    public boolean isHidden(File var1);

    public long lastModified(File var1);

    public long length(File var1);

    public boolean createNewFile(File var1) throws IOExceptionUnchecked;

    public boolean delete(File var1);

    public String[] list(File var1);

    public String[] list(File var1, FilenameFilter var2);

    public File[] listFiles(File var1);

    public File[] listFiles(File var1, FilenameFilter var2);

    public File[] listFiles(File var1, FileFilter var2);

    public boolean mkdir(File var1);

    public boolean mkdirs(File var1);

    public boolean rename(File var1, File var2);

    public boolean setLastModified(File var1, long var2);

    public boolean setReadOnly(File var1);

    public File createTempFile(String var1, String var2, File var3) throws IOExceptionUnchecked;

    public File createTempFile(String var1, String var2) throws IOExceptionUnchecked;

    public List<File> listFiles(File var1, String[] var2, boolean var3);

    public List<File> listDirectories(File var1, boolean var2);

    public List<File> listFilesAndDirectories(File var1, boolean var2);

    public long lastChanged(File var1) throws UnknownLastChangedException;

    public long lastChanged(File var1, boolean var2, long var3) throws UnknownLastChangedException;

    public long lastChangedRelative(File var1, boolean var2, long var3) throws UnknownLastChangedException;

    public String checkPathFullyAccessible(File var1, String var2);

    public String checkPathReadAccessible(File var1, String var2);

    public String checkDirectoryFullyAccessible(File var1, String var2);

    public String checkDirectoryReadAccessible(File var1, String var2);

    public String checkFileReadAccessible(File var1, String var2);

    public String checkFileFullyAccessible(File var1, String var2);

    public void touch(File var1) throws IOExceptionUnchecked;

    public void deleteRecursively(File var1) throws IOExceptionUnchecked;

    public boolean removeRecursivelyQueueing(File var1);

    public void moveToDirectory(File var1, File var2) throws IOExceptionUnchecked;

    public void move(File var1, File var2) throws IOExceptionUnchecked;

    public void copy(File var1, File var2) throws IOExceptionUnchecked;

    public void copyToDirectory(File var1, File var2) throws IOExceptionUnchecked;

    public void copyToDirectoryAs(File var1, File var2, String var3) throws IOExceptionUnchecked;

    public void copyDirectory(File var1, File var2) throws IOExceptionUnchecked;

    public void copyFile(File var1, File var2) throws IOExceptionUnchecked;

    public void copyFileToDirectory(File var1, File var2) throws IOExceptionUnchecked;

    public void copyDirectoryToDirectory(File var1, File var2) throws IOExceptionUnchecked;

    public byte[] getContentAsByteArray(File var1) throws IOExceptionUnchecked;

    public String getContentAsString(File var1) throws IOExceptionUnchecked;

    public String getExactContentAsString(File var1) throws IOExceptionUnchecked;

    public List<String> getContentAsStringList(File var1) throws IOExceptionUnchecked;

    public InputStream getInputStream(File var1) throws IOExceptionUnchecked;

    public IInputStream getIInputStream(File var1) throws IOExceptionUnchecked;

    public OutputStream getOutputStream(File var1) throws IOExceptionUnchecked;

    public IOutputStream getIOutputStream(File var1) throws IOExceptionUnchecked;

    public void writeToFile(File var1, String var2) throws IOExceptionUnchecked;

    public long freeSpaceKb(String var1) throws IOExceptionUnchecked;
}

