/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.io.ICloseable;
import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.collections.ExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.collections.ExtendedLinkedBlockingQueue;
import ch.systemsx.cisd.common.collections.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.collections.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.collections.QueuePersister;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IFileRemover;
import ch.systemsx.cisd.common.filesystem.LoggingPathRemoverDecorator;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueingPathRemoverService {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, QueueingPathRemoverService.class);
    @Private
    static final String SHREDDER_PREFIX = ".SHREDDER_";
    private static final AtomicInteger counter = new AtomicInteger();
    private static IExtendedBlockingQueue<File> queue = null;
    private static ICloseable queueCloseableOrNull = null;
    private static Thread thread = null;
    private static IFileRemover deepRemover = null;

    public static final void start() {
        QueueingPathRemoverService.start(null);
    }

    public static final void start(File queueFileOrNull) {
        QueueingPathRemoverService.start(queueFileOrNull, TimingParameters.getDefaultParameters());
    }

    public static final synchronized void start(File queueFileOrNull, TimingParameters parameters) {
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        IFileOperations monitoringProxy = FileOperations.createMonitoredInstance(parameters);
        deepRemover = new LoggingPathRemoverDecorator(monitoringProxy, logger, false);
        if (queueFileOrNull != null) {
            PersistentExtendedBlockingQueueDecorator<File> persistentQueue = ExtendedBlockingQueueFactory.createSmartPersist(queueFileOrNull);
            queue = persistentQueue;
            queueCloseableOrNull = persistentQueue;
        } else {
            queue = new ExtendedLinkedBlockingQueue<File>();
        }
        thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        File fileToRemove = (File)queue.peekWait();
                        deepRemover.removeRecursively(fileToRemove);
                        queue.take();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {}
            }
        }, "Shredder Queue");
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean removeRecursively(File fileToRemove) {
        if (!QueueingPathRemoverService.isRunning()) {
            throw new IllegalStateException("Cannot remove the file because the shreder is already stopped: " + fileToRemove);
        }
        if (fileToRemove.isFile()) {
            return fileToRemove.delete();
        }
        String name = SHREDDER_PREFIX + System.currentTimeMillis() + "-" + counter.incrementAndGet() + "-" + fileToRemove.getName();
        File shredderFile = new File(fileToRemove.getParentFile(), name);
        boolean ok = fileToRemove.renameTo(shredderFile);
        if (ok) {
            queue.add(shredderFile);
        }
        return ok;
    }

    private static final void close() {
        if (queueCloseableOrNull != null) {
            queueCloseableOrNull.close();
        }
    }

    public static final synchronized void stop() {
        if (thread == null) {
            return;
        }
        thread.interrupt();
        QueueingPathRemoverService.close();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        deepRemover = null;
    }

    public static final synchronized boolean stopAndWait(long timeoutMillis) {
        if (thread == null) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {}
        QueueingPathRemoverService.close();
        boolean ok = !thread.isAlive();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        deepRemover = null;
        return ok;
    }

    public static final synchronized boolean isRunning() {
        return deepRemover != null;
    }

    public static final List<File> listShredderItems(File queueFile) {
        return QueuePersister.list(File.class, queueFile);
    }

    private QueueingPathRemoverService() {
    }
}

