/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.hdf5;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.hdf5.HDF5FactoryProvider;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HDF5ContainerReader
implements IHDF5ContainerReader {
    private final byte[] buffer = new byte[0xA00000];
    private final IHDF5Reader innerReader;

    HDF5ContainerReader(File hdf5Container) {
        this.innerReader = HDF5FactoryProvider.get().openForReading(hdf5Container);
    }

    @Override
    public void close() {
        this.innerReader.close();
    }

    @Override
    public boolean exists(String objectPath) {
        return this.innerReader.exists(objectPath);
    }

    @Override
    public boolean isGroup(String objectPath) {
        return this.innerReader.isGroup(objectPath);
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        return this.innerReader.getGroupMembers(groupPath);
    }

    private long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(this.buffer))) {
            output.write(this.buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    @Override
    public void readFromHDF5Container(String objectPath, OutputStream ostream) {
        InputStream istream = HDF5IOAdapterFactory.asInputStream((IHDF5Reader)this.innerReader, (String)objectPath);
        IOException e = null;
        try {
            try {
                this.copy(istream, ostream);
            }
            catch (IOException ex) {
                e = ex;
                throw new IOExceptionUnchecked(ex);
            }
        }
        finally {
            block10: {
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    if (e != null) break block10;
                    throw new IOExceptionUnchecked(ex);
                }
            }
        }
    }
}

