/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.hdf5;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.hdf5.HDF5Container;
import ch.systemsx.cisd.common.hdf5.IHDF5ContainerWriter;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HDF5ContainerWriter
implements IHDF5ContainerWriter {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int COMPACT_SIZE_LIMIT = 8192;
    private static final String OPAQUE_TAG_FILE = "FILE";
    static final int BUFFER_SIZE = 0xA00000;
    private final byte[] buffer = new byte[0xA00000];
    private final IHDF5Writer writer;
    private final HDF5GenericStorageFeatures genericStorageFeatures;

    HDF5ContainerWriter(HDF5Container parent, IHDF5Writer writer, boolean compress) {
        this.writer = writer;
        this.genericStorageFeatures = compress ? HDF5GenericStorageFeatures.GENERIC_DEFLATE : HDF5GenericStorageFeatures.GENERIC_CHUNKED;
    }

    private long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(this.buffer))) {
            output.write(this.buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public void writeToHDF5Container(String objectPath, InputStream istream, long size) throws IOExceptionUnchecked {
        OutputStream ostream = size <= 8192L ? HDF5IOAdapterFactory.asOutputStream((IHDF5Writer)this.writer, (String)objectPath, (HDF5GenericStorageFeatures)HDF5GenericStorageFeatures.GENERIC_COMPACT_DELETE, (int)((int)size), (String)OPAQUE_TAG_FILE) : HDF5IOAdapterFactory.asOutputStream((IHDF5Writer)this.writer, (String)objectPath, (HDF5GenericStorageFeatures)this.genericStorageFeatures, (int)((int)Math.min(size, 0xA00000L)), (String)OPAQUE_TAG_FILE);
        IOException e = null;
        try {
            try {
                this.copy(istream, ostream);
            }
            catch (IOException ex) {
                e = ex;
                throw new IOExceptionUnchecked(ex);
            }
        }
        finally {
            block10: {
                try {
                    ostream.close();
                }
                catch (IOException ex) {
                    if (e != null) break block10;
                    throw new IOExceptionUnchecked(ex);
                }
            }
        }
    }

    public void close() {
        this.writer.close();
    }
}

