/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io.hierarchical_content;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchicalContentNode
implements IHierarchicalContentNode {
    static final String OPERATION_NOT_SUPPORTED_FOR_A_DIRECTORY = "Operation not supported for a directory";
    static final String OPERATION_SUPPORTED_ONLY_FOR_A_DIRECTORY = "Operation supported only for a directory";
    private String relativePath;

    protected abstract String doGetRelativePath();

    protected abstract List<IHierarchicalContentNode> doGetChildNodes();

    protected abstract long doGetFileLength();

    protected abstract IRandomAccessFile doGetFileContent();

    protected abstract InputStream doGetInputStream();

    @Override
    public final String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = this.doGetRelativePath();
        }
        return this.relativePath;
    }

    private final void requireDirectory() {
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException(OPERATION_SUPPORTED_ONLY_FOR_A_DIRECTORY);
        }
    }

    private final void failOnDirectory() {
        if (this.isDirectory()) {
            throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_FOR_A_DIRECTORY);
        }
    }

    @Override
    public final List<IHierarchicalContentNode> getChildNodes() {
        this.requireDirectory();
        return this.doGetChildNodes();
    }

    @Override
    public final long getFileLength() throws UnsupportedOperationException {
        this.failOnDirectory();
        return this.doGetFileLength();
    }

    @Override
    public final IRandomAccessFile getFileContent() {
        this.failOnDirectory();
        return this.doGetFileContent();
    }

    @Override
    public final InputStream getInputStream() {
        this.failOnDirectory();
        return this.doGetInputStream();
    }

    @Override
    public final String getParentRelativePath() {
        return FileUtilities.getParentRelativePath(this.getRelativePath());
    }
}

