/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io.hierarchical_content;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.common.shared.basic.utils.StringUtils;
import ch.systemsx.cisd.common.utilities.IDelegatedAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileBasedHierarchicalContent
implements IHierarchicalContent {
    private final IHierarchicalContentFactory hierarchicalContentFactory;
    private final File root;
    private final IDelegatedAction onCloseAction;
    private IHierarchicalContentNode rootNode;

    DefaultFileBasedHierarchicalContent(IHierarchicalContentFactory hierarchicalContentFactory, File file, IDelegatedAction onCloseAction) {
        assert (hierarchicalContentFactory != null);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " is not a directory");
        }
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.onCloseAction = onCloseAction;
        this.root = file;
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.createFileNode(this.root);
        }
        return this.rootNode;
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) {
        if (StringUtils.isBlank(relativePath)) {
            return this.getRootNode();
        }
        if (relativePath.startsWith("../") || relativePath.contains("/../")) {
            throw new IllegalArgumentException("Can't access resource '" + relativePath + "' which is above the root directory.");
        }
        return this.asNode(new File(this.root, relativePath));
    }

    private IHierarchicalContentNode asNode(File file) {
        if (file.exists()) {
            return this.createFileNode(file);
        }
        File existingFile = file;
        while (existingFile != null && !existingFile.exists()) {
            existingFile = existingFile.getParentFile();
        }
        if (existingFile != null && FileUtilities.isHDF5ContainerFile(existingFile)) {
            HDF5ContainerBasedHierarchicalContentNode containerNode = new HDF5ContainerBasedHierarchicalContentNode(this, existingFile);
            String relativePath = FileUtilities.getRelativeFilePath(existingFile, file);
            return containerNode.getChildNode(relativePath);
        }
        throw new IllegalArgumentException("Resource '" + FileUtilities.getRelativeFilePath(this.root, file) + "' does not exist.");
    }

    private IHierarchicalContentNode createFileNode(File file) {
        return this.hierarchicalContentFactory.asHierarchicalContentNode(this, file);
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        IHierarchicalContentNode startingNode = this.getRootNode();
        final Pattern compiledPattern = Pattern.compile(relativePathPattern);
        IHierarchicalContentNodeFilter relativePathFilter = new IHierarchicalContentNodeFilter(){

            public boolean accept(IHierarchicalContentNode node) {
                return compiledPattern.matcher(node.getRelativePath()).matches();
            }
        };
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        DefaultFileBasedHierarchicalContent.findMatchingNodes(startingNode, relativePathFilter, result);
        return result;
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        IHierarchicalContentNode startingNode = this.getNode(startingPath);
        final Pattern compiledPattern = Pattern.compile(fileNamePattern);
        IHierarchicalContentNodeFilter fileNameFilter = new IHierarchicalContentNodeFilter(){

            public boolean accept(IHierarchicalContentNode node) {
                return compiledPattern.matcher(node.getName()).matches();
            }
        };
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        DefaultFileBasedHierarchicalContent.findMatchingNodes(startingNode, fileNameFilter, result);
        return result;
    }

    @Override
    public void close() {
        this.onCloseAction.execute();
    }

    public String toString() {
        return "DefaultFileBasedHierarchicalContent [root=" + this.root + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFileBasedHierarchicalContent)) {
            return false;
        }
        DefaultFileBasedHierarchicalContent other = (DefaultFileBasedHierarchicalContent)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    private static void findMatchingNodes(IHierarchicalContentNode dirNode, IHierarchicalContentNodeFilter filter, List<IHierarchicalContentNode> result) {
        assert (dirNode.isDirectory()) : "expected a directory node, got: " + dirNode;
        for (IHierarchicalContentNode childNode : dirNode.getChildNodes()) {
            if (filter.accept(childNode)) {
                result.add(childNode);
            }
            if (!childNode.isDirectory()) continue;
            DefaultFileBasedHierarchicalContent.findMatchingNodes(childNode, filter, result);
        }
    }
}

