/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io.hierarchical_content;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.hierarchical_content.DefaultFileBasedHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.common.io.hierarchical_content.VirtualHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.common.utilities.IDelegatedAction;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileBasedHierarchicalContentFactory
implements IHierarchicalContentFactory {
    @Override
    public IHierarchicalContent asVirtualHierarchicalContent(List<IHierarchicalContent> components) {
        return new VirtualHierarchicalContent(components);
    }

    @Override
    public IHierarchicalContent asHierarchicalContent(File file, IDelegatedAction onCloseAction) {
        return new DefaultFileBasedHierarchicalContent(this, file, onCloseAction);
    }

    @Override
    public IHierarchicalContentNode asHierarchicalContentNode(IHierarchicalContent rootContent, File file) {
        if (FileUtilities.isHDF5ContainerFile(file)) {
            return new HDF5ContainerBasedHierarchicalContentNode(rootContent, file);
        }
        return new DefaultFileBasedHierarchicalContentNode(this, rootContent, file);
    }
}

