/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.hierarchical_content.AbstractHierarchicalContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileBasedHierarchicalContentNode
extends AbstractHierarchicalContentNode {
    protected final IHierarchicalContent root;
    protected final File file;
    private final IHierarchicalContentFactory hierarchicalContentFactoryOrNull;

    protected DefaultFileBasedHierarchicalContentNode(IHierarchicalContent root, File file) {
        this(null, root, file);
    }

    protected DefaultFileBasedHierarchicalContentNode(IHierarchicalContentFactory hierarchicalContentFactoryOrNull, IHierarchicalContent root, File file) {
        assert (root != null);
        assert (file != null);
        this.hierarchicalContentFactoryOrNull = hierarchicalContentFactoryOrNull;
        this.root = root;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String doGetRelativePath() {
        return FileUtilities.getRelativeFilePath(this.root.getRootNode().getFile(), this.file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public List<IHierarchicalContentNode> doGetChildNodes() {
        assert (this.hierarchicalContentFactoryOrNull != null);
        File[] files = this.file.listFiles();
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File aFile = fileArray[n2];
                result.add(this.hierarchicalContentFactoryOrNull.asHierarchicalContentNode(this.root, aFile));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public long doGetFileLength() {
        return this.file.length();
    }

    @Override
    public IRandomAccessFile doGetFileContent() {
        return new RandomAccessFileImpl(this.file, "r");
    }

    @Override
    public InputStream doGetInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public String toString() {
        return "DefaultFileBasedHierarchicalContentNode [root=" + this.root + ", file=" + this.file + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.file.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFileBasedHierarchicalContentNode)) {
            return false;
        }
        DefaultFileBasedHierarchicalContentNode other = (DefaultFileBasedHierarchicalContentNode)obj;
        if (!this.file.equals(other.file)) {
            return false;
        }
        return this.root.equals(other.root);
    }
}

