/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.LogCategory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogFactory {
    private LogFactory() {
    }

    public static String getLoggerName(LogCategory category, Class<?> clazz) {
        return String.valueOf(category.name()) + "." + clazz.getSimpleName();
    }

    public static String getLoggerName(LogCategory category) {
        if (!category.isAdminLog()) {
            throw new IllegalArgumentException("Only admin logs are allowed here, but we got " + (Object)((Object)category) + ".");
        }
        return category.name();
    }

    public static Logger getLogger(LogCategory category, Class<?> clazz) {
        return Logger.getLogger((String)LogFactory.getLoggerName(category, clazz));
    }

    public static Logger getLogger(LogCategory category) {
        return Logger.getLogger((String)LogFactory.getLoggerName(category));
    }
}

