/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.maintenance;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.MaintenancePlugin;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.utilities.PropertyParametersUtil;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MaintenanceTaskUtils {
    public static final String DEFAULT_MAINTENANCE_PLUGINS_PROPERTY_NAME = "maintenance-plugins";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MaintenanceTaskUtils.class);

    public static void startupMaintenancePlugins(MaintenanceTaskParameters[] maintenancePlugins) {
        ArrayList<MaintenancePlugin> plugins = new ArrayList<MaintenancePlugin>();
        MaintenanceTaskParameters[] maintenanceTaskParametersArray = maintenancePlugins;
        int n = maintenancePlugins.length;
        int n2 = 0;
        while (n2 < n) {
            MaintenanceTaskParameters parameters = maintenanceTaskParametersArray[n2];
            MaintenancePlugin plugin = new MaintenancePlugin(parameters);
            plugins.add(plugin);
            ++n2;
        }
        for (MaintenancePlugin plugin : plugins) {
            plugin.start();
        }
    }

    public static void injectMaintenancePlugin(MaintenancePlugin plugin) {
        plugin.start();
    }

    public static MaintenanceTaskParameters[] createMaintenancePlugins(Properties serviceProperties) {
        return MaintenanceTaskUtils.createMaintenancePlugins(serviceProperties, DEFAULT_MAINTENANCE_PLUGINS_PROPERTY_NAME);
    }

    public static MaintenanceTaskParameters[] createMaintenancePlugins(Properties serviceProperties, String maintenancePluginsPropertyName) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PropertyParametersUtil.extractSectionProperties(serviceProperties, DEFAULT_MAINTENANCE_PLUGINS_PROPERTY_NAME, true);
        return MaintenanceTaskUtils.asMaintenanceParameters(sectionsProperties);
    }

    private static MaintenanceTaskParameters[] asMaintenanceParameters(PropertyParametersUtil.SectionProperties[] sectionProperties) {
        MaintenanceTaskParameters[] maintenanceParameters = new MaintenanceTaskParameters[sectionProperties.length];
        int i = 0;
        while (i < maintenanceParameters.length) {
            PropertyParametersUtil.SectionProperties section = sectionProperties[i];
            operationLog.info((Object)("Create parameters for maintenance plugin '" + section.getKey() + "'."));
            maintenanceParameters[i] = new MaintenanceTaskParameters(section.getProperties(), section.getKey());
            ++i;
        }
        return maintenanceParameters;
    }
}

