/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ILineTokenizer;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.shared.basic.utils.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.NumberToTextConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRowTokenizer
implements ILineTokenizer<Row> {
    @Override
    public void init() {
    }

    @Override
    public String[] tokenize(Row row) throws ParserException {
        return ExcelRowTokenizer.tokenizeRow(row);
    }

    public static String[] tokenizeRow(Row row) {
        String[] line = new String[row.getLastCellNum()];
        int i = 0;
        while (i < line.length) {
            line[i] = "";
            ++i;
        }
        for (Cell cell : row) {
            String value;
            line[cell.getColumnIndex()] = value = ExcelRowTokenizer.extractCellValue(cell).trim();
        }
        return ExcelRowTokenizer.trimEmptyCells(line);
    }

    private static String[] trimEmptyCells(String[] line) {
        int last = -1;
        int i = line.length - 1;
        while (i >= 0) {
            if (!StringUtils.isBlank(line[i])) {
                if (line.length - 1 == i) {
                    return line;
                }
                last = i;
                break;
            }
            --i;
        }
        if (last < 0) {
            return new String[0];
        }
        String[] result = new String[last + 1];
        System.arraycopy(line, 0, result, 0, last + 1);
        return result;
    }

    private static String extractCellValue(Cell cell) throws ParserException {
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 0: {
                return NumberToTextConverter.toText((double)cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                throw new ParserException("Excel formulas are not supported but one was found in cell " + ExcelRowTokenizer.extractCellPosition(cell));
            }
            case 5: {
                throw new ParserException("There is an error in cell " + ExcelRowTokenizer.extractCellPosition(cell));
            }
        }
        throw new ParserException("Unknown data type of cell " + ExcelRowTokenizer.extractCellPosition(cell));
    }

    private static String extractCellPosition(Cell cell) {
        String col = CellReference.convertNumToColString((int)cell.getColumnIndex());
        String row = "" + (cell.getRowIndex() + 1);
        return String.valueOf(col) + row;
    }

    @Override
    public void destroy() {
    }
}

