/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.DefaultLineTokenizer;
import ch.systemsx.cisd.common.parser.DefaultParser;
import ch.systemsx.cisd.common.parser.DefaultPropertyMapper;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.IParser;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFileLoader<T> {
    private static final String TOKENS_SEPARATOR = "\t";
    public static final String COMMENT_PREFIX = "#";
    public static final Pattern COMMENT_REGEXP_PATTERN = Pattern.compile("\"*#.*");
    public static final String DEFAULT_SECTION = "[DEFAULT]";
    private final IParserObjectFactoryFactory<T> factory;

    public TabFileLoader(final Class<T> beanClass) {
        this.factory = new IParserObjectFactoryFactory<T>(){

            @Override
            public IParserObjectFactory<T> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new AbstractParserObjectFactory<T>(beanClass, propertyMapper){};
            }
        };
    }

    public TabFileLoader(IParserObjectFactoryFactory<T> factory) {
        assert (factory != null) : "Undefined factory";
        this.factory = factory;
    }

    public Iterator<T> iterate(File file, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        Iterator<T> iterator;
        assert (file != null) : "Given file must not be null";
        assert (file.isFile()) : "Given file '" + file.getAbsolutePath() + "' is not a file.";
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            iterator = this.iterate(reader, defaults);
        }
        catch (IOException ex) {
            try {
                throw new IOExceptionUnchecked(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return iterator;
    }

    public List<T> load(File file, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException, IOExceptionUnchecked {
        assert (file != null) : "Given file must not be null";
        assert (file.isFile()) : "Given file '" + file.getAbsolutePath() + "' is not a file.";
        FileInputStream inputStream = null;
        try {
            inputStream = FileUtils.openInputStream((File)file);
            List<T> list = this.load(inputStream, defaults);
            return list;
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public Iterator<T> iterate(Reader reader, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (reader != null) : "Unspecified reader";
        Iterator<ILine<String>> lineIterator = TabFileLoader.createLineIterator(reader);
        return this.iterate(lineIterator, defaults);
    }

    public List<T> load(Reader reader, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (reader != null) : "Unspecified reader";
        Iterator<ILine<String>> lineIterator = TabFileLoader.createLineIterator(reader);
        return this.load(lineIterator, defaults);
    }

    public Iterator<T> iterate(InputStream stream, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (stream != null) : "Unspecified stream";
        try {
            Iterator<ILine<String>> lineIterator = TabFileLoader.createLineIterator(stream);
            return this.iterate(lineIterator, defaults);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public List<T> load(InputStream stream, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (stream != null) : "Unspecified stream";
        try {
            Iterator<ILine<String>> lineIterator = TabFileLoader.createLineIterator(stream);
            return this.load(lineIterator, defaults);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public static final Map<String, String> parseDefaults(Reader reader) {
        Iterator<ILine<String>> lineIterator = TabFileLoader.createLineIterator(reader);
        HashMap<String, String> defaults = new HashMap<String, String>();
        return TabFileLoader.parseDefaults(lineIterator, defaults);
    }

    private static final Map<String, String> parseDefaults(Iterator<ILine<String>> lineIterator, Map<String, String> defaults) {
        while (lineIterator.hasNext()) {
            ILine<String> line = lineIterator.next();
            String text = line.getText();
            if (DEFAULT_SECTION.equals(text.trim())) break;
            int separatorIdx = text.indexOf(TOKENS_SEPARATOR);
            if (separatorIdx <= -1) continue;
            String name = text.substring(0, separatorIdx);
            String value = text.substring(separatorIdx + 1);
            defaults.put(name.toLowerCase(), value);
        }
        return defaults;
    }

    private List<T> load(Iterator<ILine<String>> lineIterator, Map<String, String> fileDefaults) {
        ILine<String> previousLine = null;
        ILine<String> line = null;
        boolean previousLineHasColumnHeaders = false;
        HashMap<String, String> defaults = new HashMap<String, String>(fileDefaults);
        while (lineIterator.hasNext()) {
            previousLineHasColumnHeaders = previousLine != null && TabFileLoader.isComment(previousLine);
            previousLine = line;
            line = lineIterator.next();
            if (TabFileLoader.startsWithComment(line)) continue;
            if (TabFileLoader.startsDefaultSection(line)) {
                TabFileLoader.parseDefaults(lineIterator, defaults);
                previousLine = null;
                line = null;
                previousLineHasColumnHeaders = false;
                continue;
            }
            if (!TabFileLoader.startsWithComment(line)) break;
        }
        if (line == null) {
            return new ArrayList();
        }
        String headerLine = previousLineHasColumnHeaders && previousLine != null ? TabFileLoader.trimComment(previousLine) : line.getText();
        IParser<T, String> parser = this.createParser();
        String[] tokens = StringUtils.split((String)headerLine, (String)TOKENS_SEPARATOR);
        int lastEmptyHeadersToSkip = TabFileLoader.countLastEmptyTokens(headerLine);
        int headerLength = tokens.length;
        TabFileLoader.notUnique(tokens);
        DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper(tokens, defaults);
        parser.setObjectFactory(this.factory.createFactory(propertyMapper));
        ILine<String> firstContentLine = previousLineHasColumnHeaders ? line : null;
        Iterator contentLineIterator = TabFileLoader.createContentIterator(firstContentLine, lineIterator, lastEmptyHeadersToSkip);
        ILineFilter filter = AlwaysAcceptLineFilter.INSTANCE;
        return parser.parse(contentLineIterator, filter, headerLength);
    }

    private Iterator<T> iterate(Iterator<ILine<String>> lineIterator, Map<String, String> fileDefaults) {
        ILine<String> previousLine = null;
        ILine<String> line = null;
        boolean previousLineHasColumnHeaders = false;
        HashMap<String, String> defaults = new HashMap<String, String>(fileDefaults);
        while (lineIterator.hasNext()) {
            previousLineHasColumnHeaders = previousLine != null && TabFileLoader.isComment(previousLine);
            previousLine = line;
            line = lineIterator.next();
            if (TabFileLoader.startsWithComment(line)) continue;
            if (TabFileLoader.startsDefaultSection(line)) {
                TabFileLoader.parseDefaults(lineIterator, defaults);
                previousLine = null;
                line = null;
                previousLineHasColumnHeaders = false;
                continue;
            }
            if (!TabFileLoader.startsWithComment(line)) break;
        }
        if (line == null) {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        String headerLine = previousLineHasColumnHeaders && previousLine != null ? TabFileLoader.trimComment(previousLine) : line.getText();
        IParser<T, String> parser = this.createParser();
        String[] tokens = StringUtils.split((String)headerLine, (String)TOKENS_SEPARATOR);
        int lastEmptyHeadersToSkip = TabFileLoader.countLastEmptyTokens(headerLine);
        int headerLength = tokens.length;
        TabFileLoader.notUnique(tokens);
        DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper(tokens, defaults);
        parser.setObjectFactory(this.factory.createFactory(propertyMapper));
        ILine<String> firstContentLine = previousLineHasColumnHeaders ? line : null;
        Iterator contentLineIterator = TabFileLoader.createContentIterator(firstContentLine, lineIterator, lastEmptyHeadersToSkip);
        ILineFilter filter = AlwaysAcceptLineFilter.INSTANCE;
        return parser.parseIteratively(contentLineIterator, filter, headerLength);
    }

    private static boolean startsDefaultSection(ILine<String> line) {
        String text = line.getText();
        return DEFAULT_SECTION.equals(text.trim());
    }

    private static boolean startsWithComment(ILine<String> line) {
        String text = line.getText();
        return COMMENT_REGEXP_PATTERN.matcher(text).matches();
    }

    private static String trimComment(ILine<String> previousLine) {
        String text = previousLine.getText().trim();
        if (text.startsWith(COMMENT_PREFIX)) {
            return text.substring(COMMENT_PREFIX.length());
        }
        return text;
    }

    private static boolean isComment(ILine<String> line) {
        String text = line.getText();
        return COMMENT_PREFIX.equals(text);
    }

    private static Iterator<ILine<String>> createContentIterator(ILine<String> firstContentLineOrNull, final Iterator<ILine<String>> lineIterator, final int lastEmptyTokensToSkip) {
        final String suffixToDelete = TabFileLoader.multiply(lastEmptyTokensToSkip, TOKENS_SEPARATOR);
        return new Iterator<ILine<String>>(firstContentLineOrNull){
            private ILine<String> firstLineOrNull;
            {
                this.firstLineOrNull = iLine;
            }

            @Override
            public boolean hasNext() {
                return this.firstLineOrNull != null || lineIterator.hasNext();
            }

            @Override
            public ILine<String> next() {
                return this.trim(this.nextUntrimmed());
            }

            private ILine<String> trim(ILine<String> line) {
                if (lastEmptyTokensToSkip == 0) {
                    return line;
                }
                String text = this.trim(line.getText(), line.getNumber());
                return new Line(line.getNumber(), text);
            }

            private String trim(String text, int lineNumber) {
                if (text.endsWith(suffixToDelete)) {
                    return text.substring(0, text.length() - suffixToDelete.length());
                }
                throw new ParsingException(new String[]{text}, lineNumber){
                    private static final long serialVersionUID = 1L;

                    public final String getMessage() {
                        return String.valueOf(super.getMessage()) + " The line was expected to be followed by as many separators as the header.";
                    }
                };
            }

            private ILine<String> nextUntrimmed() {
                if (this.firstLineOrNull != null) {
                    ILine<String> line = this.firstLineOrNull;
                    this.firstLineOrNull = null;
                    return line;
                }
                return (ILine)lineIterator.next();
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    private static String multiply(int number, String text) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < number) {
            sb.append(text);
            ++i;
        }
        return sb.toString();
    }

    private static int countLastEmptyTokens(String text) {
        String rest = text;
        int counter = 0;
        while (rest.endsWith(TOKENS_SEPARATOR)) {
            rest = rest.substring(0, rest.length() - TOKENS_SEPARATOR.length());
            ++counter;
        }
        return counter;
    }

    private static Iterator<ILine<String>> createLineIterator(Reader reader) {
        LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
        TabFileLineIterator iterator = new TabFileLineIterator(lineIterator);
        return iterator;
    }

    private static Iterator<ILine<String>> createLineIterator(InputStream stream) throws IOException {
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)stream, (String)"UTF-8");
        TabFileLineIterator iterator = new TabFileLineIterator(lineIterator);
        return iterator;
    }

    private static final void notUnique(String[] tokens) {
        assert (tokens != null) : "Given tokens can not be null.";
        HashSet<String> unique = new HashSet<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!unique.add(token.toLowerCase())) {
                throw new IllegalArgumentException(String.format("Duplicated column name '%s'.", token));
            }
            ++n2;
        }
    }

    private final <E> IParser<E, String> createParser() {
        DefaultLineTokenizer tokenizer = new DefaultLineTokenizer();
        tokenizer.setProperty(DefaultLineTokenizer.PropertyKey.QUOTE_CHARS, "'\"");
        return new DefaultParser(tokenizer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TabFileLineIterator
    implements Iterator<ILine<String>> {
        private final LineIterator lineIterator;
        private int lineNumber;

        TabFileLineIterator(LineIterator lineIterator) {
            this.lineIterator = lineIterator;
        }

        @Override
        public final void remove() {
            this.lineIterator.remove();
        }

        @Override
        public final ILine<String> next() {
            return new Line(++this.lineNumber, this.lineIterator.nextLine());
        }

        @Override
        public final boolean hasNext() {
            return this.lineIterator.hasNext();
        }
    }
}

