/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallableExecutor {
    private final int maxRetriesOnFailure;
    private final long millisToSleepOnFailure;

    public CallableExecutor() {
        this(11, 10000L);
    }

    public CallableExecutor(int maxRetriesOnFailure, long millisToSleepOnFailure) {
        assert (millisToSleepOnFailure > -1L) : "Negative value";
        assert (maxRetriesOnFailure > -1) : "Negative value";
        this.maxRetriesOnFailure = maxRetriesOnFailure;
        this.millisToSleepOnFailure = millisToSleepOnFailure;
    }

    public final <T> T executeCallable(Callable<T> callable) throws InterruptedExceptionUnchecked {
        int counter = 0;
        T result = null;
        try {
            do {
                InterruptedExceptionUnchecked.check();
                result = callable.call();
                if (result != null || ++counter >= this.maxRetriesOnFailure || this.millisToSleepOnFailure <= 0L) continue;
                Thread.sleep(this.millisToSleepOnFailure);
            } while (result == null && counter < this.maxRetriesOnFailure);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        return result;
    }
}

