/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.process.IProcessHandler;
import ch.systemsx.cisd.common.process.ProcessExecutor;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessExecutionHelper {
    public static final int RECOMMENDED_BUFFER_SIZE = 4096;
    @Deprecated
    public static final OutputReadingStrategy DEFAULT_OUTPUT_READING_STRATEGY = OutputReadingStrategy.ALWAYS;

    public static final boolean log(ProcessResult result) throws InterruptedExceptionUnchecked {
        result.log();
        if (result.isInterruped()) {
            throw new InterruptedExceptionUnchecked();
        }
        return result.isOK();
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, -1L, ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.run(cmd, operationLog, machineLog, true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, false));
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, false));
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, millisToWaitForCompletion, ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy ioStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, millisToWaitForCompletion, ioStrategy, operationLog, machineLog).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy processIOStrategy) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, processIOStrategy, false));
    }

    @Deprecated
    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, outputReadingStrategy, false));
    }

    @Deprecated
    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, millisToWaitForCompletion, outputReadingStrategy == OutputReadingStrategy.NEVER ? ProcessIOStrategy.DISCARD_IO_STRATEGY : ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog).run(stopOnInterrupt);
    }

    @Deprecated
    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy, boolean binaryOutput, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, millisToWaitForCompletion, outputReadingStrategy == OutputReadingStrategy.NEVER ? ProcessIOStrategy.DISCARD_IO_STRATEGY : (binaryOutput ? ProcessIOStrategy.BINARY_IO_STRATEGY : ProcessIOStrategy.DEFAULT_IO_STRATEGY), operationLog, machineLog).run(stopOnInterrupt);
    }

    public static IProcessHandler runUnblocking(List<String> cmd, Logger operationLog, Logger machineLog, ProcessIOStrategy processIOStrategy) {
        return new ProcessExecutor(cmd, -1L, processIOStrategy, operationLog, machineLog).runUnblocking();
    }

    @Deprecated
    public static IProcessHandler runUnblocking(List<String> cmd, OutputReadingStrategy outputReadingStrategy, Logger operationLog, Logger machineLog) {
        return new ProcessExecutor(cmd, -1L, outputReadingStrategy == OutputReadingStrategy.NEVER ? ProcessIOStrategy.DISCARD_IO_STRATEGY : ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog).runUnblocking();
    }

    public static boolean readTextIfAvailable(BufferedReader reader, List<String> outputOrNull, boolean discard) throws IOException {
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null) {
                return true;
            }
            if (discard) continue;
            outputOrNull.add(line);
        }
        return true;
    }

    public static long readBytesIfAvailable(InputStream input, OutputStream outputOrNull, byte[] buffer, long maxBytes, boolean discard) throws IOException {
        long count = 0L;
        int n = 0;
        while ((maxBytes <= 0L || count < maxBytes) && input.available() > 0 && -1 != (n = input.read(buffer))) {
            if (!discard) {
                outputOrNull.write(buffer, 0, n);
            }
            count += (long)n;
        }
        return count;
    }

    static final String getCommandName(List<String> commandLine) {
        return new File(commandLine.get(0)).getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum OutputReadingStrategy {
        NEVER,
        ON_ERROR,
        ALWAYS;

    }
}

