/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation;

import java.io.Serializable;

public class ServiceMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String conversationId;
    private final int messageIdx;
    private final Serializable payload;
    private final String exceptionDescription;

    public static ServiceMessage terminate(String conversationId) {
        return new ServiceMessage(conversationId, 0, false, null);
    }

    public ServiceMessage(String conversationId, int messageId, boolean exception, Serializable payload) {
        this.conversationId = conversationId;
        this.messageIdx = messageId;
        if (exception) {
            this.payload = null;
            this.exceptionDescription = payload.toString();
        } else {
            this.payload = payload;
            this.exceptionDescription = null;
        }
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public int getMessageIdx() {
        return this.messageIdx;
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public boolean isTerminate() {
        return this.payload == null && this.exceptionDescription == null;
    }

    public boolean isException() {
        return this.payload == null && this.exceptionDescription != null;
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public String tryGetExceptionDescription() {
        return this.exceptionDescription;
    }

    public String toString() {
        if (this.isTerminate()) {
            return "ServiceMessage [conversationId=" + this.conversationId + ", TERMINATE]";
        }
        if (this.isException()) {
            return "ServiceMessage [conversationId=" + this.conversationId + ", messageIdx=" + this.messageIdx + ", exceptionDescription=" + this.exceptionDescription + "]";
        }
        return "ServiceMessage [conversationId=" + this.conversationId + ", messageIdx=" + this.messageIdx + ", payload=" + this.payload + "]";
    }
}

