/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.server;

import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationRecord;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConversationMap {
    private final int MAX_SIZE_INSPECT = 100;
    private final long MAX_AGE_MILLIS = 60000L;
    private final Map<String, ServiceConversationRecord> conversations = new ConcurrentHashMap<String, ServiceConversationRecord>();
    private final Map<String, Long> recentlySeenMap = new ConcurrentHashMap<String, Long>();

    ConversationMap() {
    }

    private void addHistoric(String serviceConversationId) {
        long now = System.currentTimeMillis();
        this.recentlySeenMap.put(serviceConversationId, now);
        this.cleanUpOld(now);
    }

    private void cleanUpOld(long now) {
        if (this.recentlySeenMap.size() > 100) {
            Iterator<Map.Entry<String, Long>> it = this.recentlySeenMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                if (now - entry.getValue() <= 60000L) continue;
                it.remove();
            }
        }
    }

    boolean recentlySeen(String serviceConversationId) {
        return this.recentlySeenMap.containsKey(serviceConversationId);
    }

    ServiceConversationRecord get(Object key) {
        return this.conversations.get(key);
    }

    ServiceConversationRecord put(String key, ServiceConversationRecord value) {
        return this.conversations.put(key, value);
    }

    ServiceConversationRecord remove(String serviceConversationId) {
        this.addHistoric(serviceConversationId);
        return this.conversations.remove(serviceConversationId);
    }

    boolean containsKey(Object key) {
        return this.conversations.containsKey(key);
    }

    Collection<ServiceConversationRecord> values() {
        return this.conversations.values();
    }
}

