/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.common.servlet.IActionLog;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.servlet.RequestContextProviderAdapter;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class AbstractActionLog
implements IActionLog {
    private static final String FAILED = "FAILED";
    private static final String OK = "OK";
    private static final String USER_SESSION_TEMPLATE = "{USER: %s, WEBSESSION: %s} logout%s";
    private static final String USER_HOST_SESSION_TEMPLATE = "{USER: %s, HOST: %s, WEBSESSION: %s} ";
    protected final Logger authenticationLog = LogFactory.getLogger(LogCategory.AUTH);
    protected final Logger accessLog = LogFactory.getLogger(LogCategory.ACCESS);
    protected final Logger trackingLog = LogFactory.getLogger(LogCategory.TRACKING);
    protected final IRequestContextProvider requestContextProvider;
    protected final IRemoteHostProvider remoteHostProvider;

    protected static String getSuccessString(boolean success) {
        return success ? OK : FAILED;
    }

    public AbstractActionLog(IRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
        this.remoteHostProvider = new RequestContextProviderAdapter(requestContextProvider);
    }

    public void logFailedLoginAttempt(String userCode) {
        if (this.authenticationLog.isInfoEnabled()) {
            String logMessage = String.format("{USER: %s, HOST: %s} login: FAILED", userCode, this.remoteHostProvider.getRemoteHost());
            this.authenticationLog.info((Object)logMessage);
        }
    }

    public void logSuccessfulLogin() {
        if (this.authenticationLog.isInfoEnabled()) {
            String userHostSessionDescription = this.getUserHostSessionDescription();
            this.authenticationLog.info((Object)(String.valueOf(userHostSessionDescription) + "login: OK"));
        }
    }

    public void logLogout(HttpSession httpSession) {
        if (this.authenticationLog.isInfoEnabled()) {
            String userName = this.getUserCode(httpSession);
            String id = httpSession.getId();
            long diff = System.currentTimeMillis() - httpSession.getLastAccessedTime();
            boolean timedOut = (double)diff / 1000.0 >= (double)httpSession.getMaxInactiveInterval();
            String logoutMsg = String.format(USER_SESSION_TEMPLATE, userName, id, timedOut ? IActionLog.LogoutReason.SESSION_TIMEOUT.getLogText() : IActionLog.LogoutReason.SESSION_LOGOUT.getLogText());
            this.authenticationLog.info((Object)logoutMsg);
        }
    }

    public void logSetSessionUser(String oldUserCode, String newUserCode, boolean success) {
        if (this.authenticationLog.isInfoEnabled()) {
            this.authenticationLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("set_user_code to '%s': %s", newUserCode, AbstractActionLog.getSuccessString(success))));
        }
    }

    protected String getUserHostSessionDescription() {
        String id;
        String userName;
        HttpSession httpSession = this.getHttpSession();
        String remoteHost = this.remoteHostProvider.getRemoteHost();
        if (httpSession == null) {
            userName = "UNKNOWN";
            id = "UNKNOWN";
        } else {
            userName = this.getUserCode(httpSession);
            id = httpSession.getId();
        }
        return String.format(USER_HOST_SESSION_TEMPLATE, userName, remoteHost, id);
    }

    protected abstract String getUserCode(HttpSession var1);

    protected HttpSession getHttpSession() {
        try {
            return this.requestContextProvider.getHttpServletRequest().getSession();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

