/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.shared.basic.utils;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char ESC = '\\';

    private StringUtils() {
    }

    public static final boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static final boolean isBlank(Object value) {
        return value == null || value.toString().trim().length() == 0;
    }

    public static final boolean isNotBlank(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static final String joinList(List<String> list) {
        if (list == null) {
            return null;
        }
        return StringUtils.join(list.toArray(new String[0]), ",");
    }

    public static final String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        String sep = separator == null ? EMPTY_STRING : separator;
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!start) {
                builder.append(sep);
            }
            builder.append(element);
            start = false;
            ++n2;
        }
        return builder.toString();
    }

    public static final String capitalize(String word) {
        if (StringUtils.isBlank(word)) {
            return word;
        }
        return String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1).toLowerCase();
    }

    public static final String abbreviate(String value, int maxLength) {
        assert (maxLength > 4);
        if (value.length() > maxLength) {
            return String.valueOf(value.substring(0, maxLength - 3)) + "...";
        }
        return value;
    }

    public static final String trimToNull(String value) {
        return StringUtils.isBlank(value) ? null : value.trim();
    }

    public static final String nullIfBlank(String value) {
        return StringUtils.isBlank(value) ? null : value;
    }

    public static final String emptyIfNull(String stringOrNull) {
        return stringOrNull == null ? EMPTY_STRING : stringOrNull;
    }

    public static final String toStringEmptyIfNull(Object objectOrNull) {
        return objectOrNull == null ? EMPTY_STRING : objectOrNull.toString();
    }

    public static final String toStringOrNull(Object objectOrNull) {
        return objectOrNull == null ? null : objectOrNull.toString();
    }

    public static final String defaultIfBlank(String str, String defaultStr) {
        return StringUtils.isBlank(str) ? defaultStr : str;
    }

    public static final String escape(String text, char ... escapedChars) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            char[] cArray = escapedChars;
            int n = escapedChars.length;
            int n2 = 0;
            while (n2 < n) {
                char escapedChar = cArray[n2];
                if (ch == escapedChar) {
                    sb.append('\\');
                }
                ++n2;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static final List<String> tokenize(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        String s = str;
        int len = s.length();
        while (len > 0) {
            char c;
            boolean quoteMode;
            int idx = 0;
            while (idx < len && s.charAt(idx) == ' ') {
                ++idx;
            }
            if (idx > 0) {
                s = s.substring(idx);
                len = s.length();
                idx = 0;
            }
            if (len == 0) break;
            char endChar = s.charAt(0);
            boolean bl = quoteMode = endChar == '\'' || endChar == '\"';
            if (!quoteMode) {
                endChar = ' ';
            } else {
                s = s.substring(1);
                --len;
            }
            while (idx < len && (c = s.charAt(idx)) != endChar) {
                if (++idx >= len || c != '\\') continue;
                ++idx;
            }
            if (idx <= 0) continue;
            tokens.add(s.substring(0, idx));
            if (idx == len) break;
            s = s.substring(idx + 1);
            len = s.length();
        }
        return tokens;
    }

    public static final native boolean matches(String var0, String var1, String var2);

    public static final native boolean matches(String var0, String var1);
}

