/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.common.spring.IInvocationLoggerFactory;
import ch.systemsx.cisd.common.utilities.MethodUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public final class LogInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Stopwatch timer = new Stopwatch();

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Object wrappedObject = invocation.getThis();
        if (!(wrappedObject instanceof IInvocationLoggerFactory)) {
            throw new IllegalArgumentException("Wrapped object isn't a " + IInvocationLoggerFactory.class.getName() + ": " + wrappedObject);
        }
        IInvocationLoggerFactory loggerFactory = (IInvocationLoggerFactory)wrappedObject;
        Object[] arguments = invocation.getArguments();
        String sessionTokenOrNull = this.tryToGetSessionToken(arguments);
        InvocationLoggerContext invocationLoggerContext = new InvocationLoggerContext(sessionTokenOrNull);
        Object logger = loggerFactory.createLogger(invocationLoggerContext);
        try {
            this.timer.start();
            Object result = invocation.proceed();
            invocationLoggerContext.invocationSuccessful = true;
            Object object = result;
            return object;
        }
        catch (Throwable th) {
            this.logError(invocation, wrappedObject, th);
            throw th;
        }
        finally {
            this.timer.stop();
            invocationLoggerContext.elapsedTime = this.timer.getTimeElapsed();
            Method method = invocation.getMethod();
            method.invoke(logger, arguments);
        }
    }

    private void logError(MethodInvocation invocation, Object wrappedObject, Throwable th) {
        Class<?> clazz = wrappedObject.getClass();
        Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, clazz);
        String errorMsg = String.format("An exception has occurred while processing method: '%s'.", MethodUtils.describeMethod(invocation.getMethod()));
        try {
            operationLog.error((Object)errorMsg, th);
        }
        catch (Exception ex) {
            operationLog.error((Object)errorMsg);
            operationLog.error((Object)"It was not possible to log the exception which caused the problem", (Throwable)ex);
        }
    }

    private String tryToGetSessionToken(Object[] arguments) {
        if (arguments.length == 0) {
            return null;
        }
        Object firstArgument = arguments[0];
        return firstArgument instanceof String ? (String)firstArgument : null;
    }

    private static final class InvocationLoggerContext
    implements IInvocationLoggerContext {
        private final String sessionToken;
        boolean invocationSuccessful;
        long elapsedTime;

        InvocationLoggerContext(String sessionTokenOrNull) {
            this.sessionToken = sessionTokenOrNull;
        }

        public String tryToGetSessionToken() {
            return this.sessionToken;
        }

        public boolean invocationWasSuccessful() {
            return this.invocationSuccessful;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    private static final class Stopwatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long start = 0L;
        private long stop = 0L;

        private Stopwatch() {
        }

        void start() {
            this.start = System.currentTimeMillis();
        }

        void stop() {
            this.stop = System.currentTimeMillis();
        }

        long getTimeElapsed() {
            return this.stop - this.start;
        }
    }
}

