/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.spring.IUncheckedMultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileAdapter
implements IUncheckedMultipartFile {
    private final MultipartFile multipartFile;

    public MultipartFileAdapter(MultipartFile multipartFile) {
        assert (multipartFile != null) : "Unspecified multipart file.";
        this.multipartFile = multipartFile;
    }

    public byte[] getBytes() {
        try {
            return this.multipartFile.getBytes();
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public String getContentType() {
        return this.multipartFile.getContentType();
    }

    public InputStream getInputStream() {
        try {
            return this.multipartFile.getInputStream();
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public String getName() {
        return this.multipartFile.getName();
    }

    public String getOriginalFilename() {
        return this.multipartFile.getOriginalFilename();
    }

    public long getSize() {
        return this.multipartFile.getSize();
    }

    public boolean isEmpty() {
        return this.multipartFile.isEmpty();
    }

    public void transferTo(File dest) {
        try {
            this.multipartFile.transferTo(dest);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }
}

